/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.config.WaitForHeaderService;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.location.SensorLocationSet;
import org.lsst.ccs.utilities.pattern.FileNamePatternUtils;

public class ImageHandlingConfig
implements ConfigurationBulkChangeHandler {
    private static final String TMP_POSTFIX = ".$tmp$";
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile String FITSRootDirectory = System.getProperty("java.io.tmpdir");
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile String FITSDirectoryPattern = "${ImageDate}/${ImageName}";
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile String FITSFilePattern = "${ImageName}_${RaftBay}_${CCDSlot}.fits";
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile boolean FITSAutoSave = true;
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile boolean useTempFile = true;
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile String tempFileRelativeLocation = ".";
    @ConfigurationParameter(category="FitsHandling", units="unitless", maxLength=10)
    private volatile String[] subsystemsToClearOnNewRun = new String[]{"bot-bench", "ccob", "bot-motorpltform"};
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile WaitForHeaderService waitForHeaderService = WaitForHeaderService.AUTO;
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    volatile boolean raiseAlertOnMissingOrBadHeaderServiceData = false;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile String daqPartition = "dev";
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile String daqFolder = "raw";
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile String locations = "R22/Reb0,R22/Reb1,R22/Reb2";
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile int daqThreads = 4;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile boolean useStreaming = false;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile boolean checkForBadPixels = false;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile int badPixelLowThreshold = 10000;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile int badPixelHighThreshold = 240000;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile int badPixelWarningLevel = 0;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile int badPixelAlarmLevel = 20000;
    @ConfigurationParameter(category="Guider", units="unitless")
    private volatile String guiderPartition = "";
    @ConfigurationParameter(category="Guider", units="unitless")
    private volatile String guiderLocations = "R00SG0,R00SG1";
    @ConfigurationParameter(category="Guider", units="unitless")
    private volatile String guiderFITSFilePattern = "${ImageName}_${RaftBay}_${CCDSlot}_guider.fits";
    @ConfigurationParameter(category="Commands", units="unitless", maxLength=20)
    private volatile List<String> commands = Collections.emptyList();
    @ConfigurationParameter(category="Commands", units="unitless", maxLength=20)
    private volatile Map<String, String> environment = Collections.emptyMap();
    @ConfigurationParameter(category="Commands", units="unitless")
    private volatile String currentDirectory = ".";
    @ConfigurationParameter(category="Commands", units="unitless")
    private volatile String logDirectory = System.getProperty("java.io.tmpdir");
    @ConfigurationParameter(category="Commands", units="unitless", maxLength=20)
    private volatile List<String> additionalFileCommands = Collections.singletonList("env");
    @ConfigurationParameter(category="Commands", units="unitless", maxLength=20)
    private volatile String additionalFileFilter = "";

    public void validateBulkChange(Map<String, Object> parametersView) {
        String dir = parametersView.get("FITSRootDirectory").toString();
        File dirFile = new File(dir);
        this.checkWritable("FITSRootDirectory", dirFile);
        String logDir = parametersView.get("logDirectory").toString();
        File logDirFile = new File(logDir);
        this.checkWritable("logDirectory", logDirFile);
        LocationSet.of((String[])new String[]{parametersView.get("locations").toString()});
        SensorLocationSet.of((String)parametersView.get("guiderLocations").toString());
    }

    private void checkWritable(String dirName, File dirFile) throws IllegalArgumentException {
        dirFile.mkdirs();
        if (!dirFile.isDirectory()) {
            throw new IllegalArgumentException(dirName + ": Not a directory");
        }
        if (!dirFile.canWrite()) {
            throw new IllegalArgumentException(dirName + ": Not writable");
        }
    }

    public String getFITSRootDirectory() {
        return this.FITSRootDirectory;
    }

    public String getFITSDirectoryPattern() {
        return this.FITSDirectoryPattern;
    }

    public String getFITSFilePattern() {
        return this.FITSFilePattern;
    }

    public boolean isFITSAutoSave() {
        return this.FITSAutoSave;
    }

    public String getDaqPartition() {
        return this.daqPartition;
    }

    LocationSet getLocationsToProcess() {
        return LocationSet.of((String[])new String[]{this.locations});
    }

    public String getDaqFolder() {
        return this.daqFolder;
    }

    public int getDaqThreads() {
        return this.daqThreads;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public List<String> getCommands() {
        return this.commands == null ? Collections.emptyList() : this.commands;
    }

    public List<String> getAdditionalFileCommands() {
        return this.additionalFileCommands == null ? Collections.emptyList() : this.additionalFileCommands;
    }

    boolean canHandleAdditionalFiles() {
        return this.additionalFileCommands != null && !this.additionalFileCommands.isEmpty();
    }

    boolean acceptAdditionalFileObsID(ImageName obsId) {
        return this.additionalFileFilter == null || this.additionalFileFilter.isBlank() || obsId.toString().startsWith(this.additionalFileFilter);
    }

    public Map<String, String> getEnvironment() {
        return this.environment == null ? Collections.emptyMap() : this.environment;
    }

    public File getCurrentDirectory() {
        return new File(this.currentDirectory);
    }

    public File getLogDirectory() {
        return new File(this.logDirectory);
    }

    FitsIntWriter.FileNamer getFileNamer(Map<File, File> tmpMap, boolean guider) {
        return props -> {
            File file = this.getFitsFile(props, guider);
            props.put("OriginalFileName", file.getName());
            if (this.isUseTempFile()) {
                File tmpFile = this.getTempFitsFile(props);
                tmpMap.put(tmpFile, file);
                return tmpFile;
            }
            return file;
        };
    }

    private File getFitsFile(Map<String, Object> data, boolean guider) {
        Map<String, String> props = data.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
        File root = new File(this.FITSRootDirectory);
        String fileDir = FileNamePatternUtils.resolveFileName((String)this.FITSDirectoryPattern, props);
        File dir = new File(root, fileDir);
        String fileName = FileNamePatternUtils.resolveFileName((String)(guider ? this.guiderFITSFilePattern : this.FITSFilePattern), props);
        File result = new File(dir, fileName);
        result.getParentFile().mkdirs();
        return result;
    }

    File getTempFitsFile(Map<String, Object> data) {
        Map<String, String> props = data.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
        File root = new File(this.FITSRootDirectory);
        String fileDir = FileNamePatternUtils.resolveFileName((String)this.FITSDirectoryPattern, props);
        File dir = new File(root, fileDir);
        dir = new File(dir, this.tempFileRelativeLocation);
        String fileName = FileNamePatternUtils.resolveFileName((String)this.FITSFilePattern, props);
        fileName = fileName + TMP_POSTFIX;
        File result = new File(dir, fileName);
        result.getParentFile().mkdirs();
        return result;
    }

    File getAdditionalFileName(AdditionalFile additionalFile, Map<String, String> props) {
        File root = new File(this.FITSRootDirectory);
        String fileDir = FileNamePatternUtils.resolveFileName((String)this.FITSDirectoryPattern, props);
        File dir = new File(root, fileDir);
        File result = new File(dir, additionalFile.getFileName());
        result.getParentFile().mkdirs();
        return result;
    }

    String[] getSubsystemsToClear() {
        return this.subsystemsToClearOnNewRun;
    }

    public int getBadPixelLowThreshold() {
        return this.badPixelLowThreshold;
    }

    public int getBadPixelHighThreshold() {
        return this.badPixelHighThreshold;
    }

    public int getBadPixelWarningLevel() {
        return this.badPixelWarningLevel;
    }

    public int getBadPixelAlarmLevel() {
        return this.badPixelAlarmLevel;
    }

    public boolean isCheckForBadPixels() {
        return this.checkForBadPixels;
    }

    public WaitForHeaderService getWaitForHeaderService() {
        return this.waitForHeaderService;
    }

    public String getGuiderPartition() {
        return this.guiderPartition;
    }

    public SensorLocationSet getGuiderLocations() {
        return SensorLocationSet.of((String)this.guiderLocations);
    }

    public boolean getRaiseAlertOnMissingOrBadHeaderServiceData() {
        return this.raiseAlertOnMissingOrBadHeaderServiceData;
    }
}

