/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.visualization.rest;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.web.visualization.rest.Image;

public class ImageQueue {
    private Image latestImage;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public void put(Image image) {
        this.lock.lock();
        try {
            this.latestImage = image;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image waitForImageNewerThan(long since, int timeout) throws InterruptedException {
        this.lock.lock();
        try {
            Image image = this.getImageNewerThan(since);
            if (image == null && timeout > 0) {
                this.condition.await(timeout, TimeUnit.SECONDS);
                image = this.getImageNewerThan(since);
            }
            Image image2 = image;
            return image2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Image getImageNewerThan(long since) {
        Image image = this.latestImage;
        if (image != null && since > 0L && image.getTimestamp() <= since) {
            image = null;
        }
        return image;
    }
}

