/*
 * Decompiled with CFR 0.152.
 */
package DDS.IoT;

import DDS.IoT.IoTData;
import DDS.IoT.IoTDataDataReaderView;
import DDS.IoT.IoTDataHolder;
import DDS.IoT.IoTDataSeqHolder;
import DDS.IoT.IoTDataTypeSupport;
import DDS.ReadCondition;
import DDS.SampleInfoHolder;
import DDS.SampleInfoSeqHolder;
import org.opensplice.dds.dcps.FooDataReaderViewImpl;
import org.opensplice.dds.dcps.ReportStack;

public class IoTDataDataReaderViewImpl
extends FooDataReaderViewImpl
implements IoTDataDataReaderView {
    private static final long serialVersionUID = 1L;
    private long copyCache;
    private IoTDataTypeSupport typeSupport;

    public IoTDataDataReaderViewImpl(IoTDataTypeSupport ts) {
        this.typeSupport = ts;
        this.copyCache = this.typeSupport.get_copyCache();
    }

    @Override
    public synchronized int read(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, int sample_states, int view_states, int instance_states) {
        long uView = 0L;
        int result = 9;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (info_seq == null) {
                result = 3;
                ReportStack.report(result, "info_seq 'null' is invalid.");
            } else if (max_samples < -1) {
                result = 3;
                ReportStack.report(result, "max_samples is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniRead(this, uView, this.copyCache, received_data, info_seq, max_samples, sample_states, view_states, instance_states);
            }
        }
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    public synchronized int take(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, int sample_states, int view_states, int instance_states) {
        long uView = 0L;
        int result = 9;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (info_seq == null) {
                result = 3;
                ReportStack.report(result, "info_seq 'null' is invalid.");
            } else if (max_samples < -1) {
                result = 3;
                ReportStack.report(result, "max_samples is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniTake(this, uView, this.copyCache, received_data, info_seq, max_samples, sample_states, view_states, instance_states);
            }
        }
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    public synchronized int read_w_condition(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, ReadCondition a_condition) {
        ReportStack.start();
        int result = this.readWCondition(this.copyCache, received_data, info_seq, max_samples, a_condition);
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    public synchronized int take_w_condition(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, ReadCondition a_condition) {
        ReportStack.start();
        int result = this.takeWCondition(this.copyCache, received_data, info_seq, max_samples, a_condition);
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    public synchronized int read_next_sample(IoTDataHolder received_data, SampleInfoHolder sample_info) {
        long uView = 0L;
        int result = 9;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (sample_info == null) {
                result = 3;
                ReportStack.report(result, "sample_info 'null' is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniReadNextSample(this, uView, this.copyCache, received_data, sample_info);
            }
        }
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    public synchronized int take_next_sample(IoTDataHolder received_data, SampleInfoHolder sample_info) {
        long uView = 0L;
        int result = 9;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (sample_info == null) {
                result = 3;
                ReportStack.report(result, "sample_info 'null' is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniTakeNextSample(this, uView, this.copyCache, received_data, sample_info);
            }
        }
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    public synchronized int read_instance(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, long a_handle, int sample_states, int view_states, int instance_states) {
        long uView = 0L;
        int result = 9;
        boolean handleExpired = false;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (info_seq == null) {
                result = 3;
                ReportStack.report(result, "info_seq 'null' is invalid.");
            } else if (max_samples < -1) {
                result = 3;
                ReportStack.report(result, "max_samples is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniReadInstance(this, uView, this.copyCache, received_data, info_seq, max_samples, a_handle, sample_states, view_states, instance_states);
                if (result == 13) {
                    result = 3;
                    handleExpired = true;
                }
            }
        }
        ReportStack.flush(this, result != 0 && result != 11 && !handleExpired);
        return result;
    }

    @Override
    public synchronized int take_instance(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, long a_handle, int sample_states, int view_states, int instance_states) {
        long uView = 0L;
        int result = 9;
        boolean handleExpired = false;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (info_seq == null) {
                result = 3;
                ReportStack.report(result, "info_seq 'null' is invalid.");
            } else if (max_samples < -1) {
                result = 3;
                ReportStack.report(result, "max_samples is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniTakeInstance(this, uView, this.copyCache, received_data, info_seq, max_samples, a_handle, sample_states, view_states, instance_states);
                if (result == 13) {
                    result = 3;
                    handleExpired = true;
                }
            }
        }
        ReportStack.flush(this, result != 0 && result != 11 && !handleExpired);
        return result;
    }

    @Override
    public synchronized int read_next_instance(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, long a_handle, int sample_states, int view_states, int instance_states) {
        long uView = 0L;
        int result = 9;
        boolean handleExpired = false;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (info_seq == null) {
                result = 3;
                ReportStack.report(result, "info_seq 'null' is invalid.");
            } else if (max_samples < -1) {
                result = 3;
                ReportStack.report(result, "max_samples is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniReadNextInstance(this, uView, this.copyCache, received_data, info_seq, max_samples, a_handle, sample_states, view_states, instance_states);
                if (result == 13) {
                    result = 3;
                    handleExpired = true;
                }
            }
        }
        ReportStack.flush(this, result != 0 && result != 11 && !handleExpired);
        return result;
    }

    @Override
    public synchronized int take_next_instance(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, long a_handle, int sample_states, int view_states, int instance_states) {
        long uView = 0L;
        int result = 9;
        boolean handleExpired = false;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (info_seq == null) {
                result = 3;
                ReportStack.report(result, "info_seq 'null' is invalid.");
            } else if (max_samples < -1) {
                result = 3;
                ReportStack.report(result, "max_samples is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniTakeNextInstance(this, uView, this.copyCache, received_data, info_seq, max_samples, a_handle, sample_states, view_states, instance_states);
                if (result == 13) {
                    result = 3;
                    handleExpired = true;
                }
            }
        }
        ReportStack.flush(this, result != 0 && result != 11 && !handleExpired);
        return result;
    }

    @Override
    public synchronized int read_next_instance_w_condition(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, long a_handle, ReadCondition a_condition) {
        boolean handleExpired = false;
        ReportStack.start();
        int result = this.readNextInstanceWCondition(this.copyCache, received_data, info_seq, max_samples, a_handle, a_condition);
        if (result == 13) {
            result = 3;
            handleExpired = true;
        }
        ReportStack.flush(this, result != 0 && result != 11 && !handleExpired);
        return result;
    }

    @Override
    public synchronized int take_next_instance_w_condition(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq, int max_samples, long a_handle, ReadCondition a_condition) {
        boolean handleExpired = false;
        ReportStack.start();
        int result = this.takeNextInstanceWCondition(this.copyCache, received_data, info_seq, max_samples, a_handle, a_condition);
        if (result == 13) {
            result = 3;
            handleExpired = true;
        }
        ReportStack.flush(this, result != 0 && result != 11 && !handleExpired);
        return result;
    }

    @Override
    public synchronized int return_loan(IoTDataSeqHolder received_data, SampleInfoSeqHolder info_seq) {
        int result;
        ReportStack.start();
        if (this.get_user_object() != 0L) {
            if (received_data == null) {
                result = 3;
                ReportStack.report(result, "received_data 'null' is invalid.");
            } else if (info_seq == null) {
                result = 3;
                ReportStack.report(result, "info_seq 'null' is invalid.");
            } else if (received_data.value != null && info_seq.value != null) {
                if (received_data.value.length == info_seq.value.length) {
                    received_data.value = null;
                    info_seq.value = null;
                    result = 0;
                } else {
                    result = 4;
                    ReportStack.report(result, "Length of received_data.value and info_seq.value are not equal.");
                }
            } else if (received_data.value == null && info_seq.value == null) {
                result = 0;
            } else if (received_data.value == null) {
                result = 4;
                ReportStack.report(result, "received_data.value is 'null' while info_seq.value is not.");
            } else {
                result = 4;
                ReportStack.report(result, "info_seq.value is 'null' while received_data.value is not.");
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public synchronized int get_key_value(IoTDataHolder key_holder, long handle) {
        long uView = 0L;
        int result = 9;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            if (key_holder == null) {
                result = 3;
                ReportStack.report(result, "key_holder 'null' is invalid.");
            } else {
                result = FooDataReaderViewImpl.jniGetKeyValue(uView, this.copyCache, key_holder, handle);
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public synchronized long lookup_instance(IoTData instance) {
        long uView = 0L;
        long handle = 0L;
        ReportStack.start();
        uView = this.get_user_object();
        if (uView != 0L) {
            handle = FooDataReaderViewImpl.jniLookupInstance(uView, this.copyCache, instance);
        }
        ReportStack.flush(this, handle == 0L);
        return handle;
    }
}

