/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeyValueParser {
    private static final Pattern PATTERN = Pattern.compile("\\s*([^:\\s]+)\\s*:\\s*(?:\\\"(.*)\\\"|\\\"(.*)\\\"|([^,\\s]+))\\s*,?");

    public static Map<String, String> parse(String keyValueData) throws ParseException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (keyValueData != null && !keyValueData.trim().isEmpty()) {
            Matcher matcher = PATTERN.matcher(keyValueData);
            int prevStart = 0;
            do {
                boolean found;
                if (!(found = matcher.find())) {
                    throw new ParseException("Illegal characters in keyValueMap: " + keyValueData, prevStart);
                }
                prevStart = matcher.end();
                String key = matcher.group(1);
                String value = matcher.group(2) != null ? matcher.group(2) : (matcher.group(3) != null ? matcher.group(3) : matcher.group(4));
                result.put(key, value);
            } while (matcher.end() != matcher.regionEnd());
        }
        return result;
    }
}

