/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneInterface;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.location.LocationSet;

public class FocalPlaneSimulation
implements FocalPlaneInterface {
    private final State raftsState;
    private final CCS ccs;

    public FocalPlaneSimulation(CCS ccs, State raftsState) {
        this.raftsState = raftsState;
        this.ccs = ccs;
    }

    @Override
    public void clear(int nClears) {
        this.raftsState.checkState(new Enum[]{FocalPlane.RaftsState.QUIESCENT, FocalPlane.RaftsState.NEEDS_CLEAR});
        this.raftsState.setState(FocalPlane.RaftsState.CLEARING);
        this.ccs.schedule(FocalPlane.CLEAR_TIME.multipliedBy(nClears), () -> this.raftsState.setState(FocalPlane.RaftsState.QUIESCENT));
    }

    @Override
    public void endIntegration(boolean readout, Duration exposure) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{FocalPlane.RaftsState.INTEGRATING});
        if (readout) {
            this.raftsState.setState(FocalPlane.RaftsState.READING_OUT);
            this.ccs.schedule(FocalPlane.READOUT_TIME, () -> this.raftsState.setState(FocalPlane.RaftsState.QUIESCENT));
        } else {
            this.raftsState.setState(FocalPlane.RaftsState.NEEDS_CLEAR);
        }
    }

    @Override
    public void start(String configName) throws ExecutionException {
    }

    @Override
    public void startIntegration(ImageName imageName, Map<String, String> parsedKeyValueData, LocationSet locations, String annotation) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{FocalPlane.RaftsState.QUIESCENT});
        this.raftsState.setState(FocalPlane.RaftsState.INTEGRATING);
    }

    @Override
    public void play(String playlist, boolean repeat) {
    }

    @Override
    public void definePlaylist(String playlist, String folder, String ... images) {
    }
}

