/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesTreeProperties;

class ResourcesUtils {
    private static final Properties defaultProperties = new Properties();

    ResourcesUtils() {
    }

    static void setDefaultProperty(String property, String value) {
        defaultProperties.setProperty(property, value);
    }

    static Properties getMergedPropertyFile(ResourcesTree tree, String fileName) {
        return ResourcesUtils.getMergedPropertyFile(tree, fileName, false);
    }

    static Properties getMergedPropertyFile(ResourcesTree tree, String fileName, boolean useSystem) {
        return ResourcesUtils.getMergedProperties(tree, new String[]{fileName}, useSystem, null, new String[]{"properties"});
    }

    static Properties getApplicationDefinitionFile(ResourcesTree tree, String fileName) {
        return ResourcesUtils.getMergedProperties(tree, new String[]{fileName, fileName}, false, null, new String[]{"app", "properties"});
    }

    static Properties getMergedProperties(ResourcesTree tree, String[] properties, boolean useSystem, ResourcesTreeProperties parentProps, String[] extensions) {
        ResourcesTreeProperties props = parentProps;
        if (useSystem) {
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Adding System Properties to the properties chain");
            }
            props = new ResourcesTreeProperties("SystemProperties", null, props);
            props.putAll((Map<?, ?>)System.getProperties());
        }
        if (properties.length != extensions.length) {
            throw new IllegalArgumentException("Inconsistent array sizes");
        }
        try {
            InputStream defaultsIn = Bootstrap.getLoaderClass().getResourceAsStream("/ccsDefaults.properties");
            Object object = null;
            try {
                if (defaultsIn != null) {
                    if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                        System.out.println("*** Adding Properties " + BootstrapUtils.getDistributionResourcesDirectory() + "ccsDefaults.properties to properties chain");
                    }
                    ResourcesTreeProperties parent = props;
                    props = new ResourcesTreeProperties("ccsDefaults", BootstrapUtils.getDistributionResourcesDirectory(), parent);
                    props.load(defaultsIn);
                    String applicationName = Bootstrap.getBootstrapApplication();
                    if (applicationName != null && !applicationName.isEmpty()) {
                        props.put("org.lsst.ccs.application.name", applicationName);
                    }
                }
            }
            catch (Throwable parent) {
                object = parent;
                throw parent;
            }
            finally {
                if (defaultsIn != null) {
                    if (object != null) {
                        try {
                            defaultsIn.close();
                        }
                        catch (Throwable parent) {
                            ((Throwable)object).addSuppressed(parent);
                        }
                    } else {
                        defaultsIn.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Properties dProperties = System.getProperties();
        for (String key : dProperties.stringPropertyNames()) {
            if (!key.startsWith("bootstrap.default.")) continue;
            defaultProperties.put(key.replace("bootstrap.default.", ""), dProperties.getProperty(key));
        }
        if (!defaultProperties.isEmpty()) {
            props = new ResourcesTreeProperties("defaults", null, props);
            props.putAll((Map<?, ?>)defaultProperties);
        }
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        ListIterator<ResourceDirectory> reverseIterator = resourceList.listIterator(resourceList.size());
        while (reverseIterator.hasPrevious()) {
            ResourceDirectory dir = reverseIterator.previous();
            for (int i = 0; i < properties.length; ++i) {
                File propertyFile;
                String propertyFileName = properties[i];
                if (propertyFileName == null) continue;
                if (!propertyFileName.endsWith(extensions[i])) {
                    propertyFileName = propertyFileName + "." + extensions[i];
                }
                if (!(propertyFile = new File(dir.getResouceDirectoryPath(), propertyFileName)).exists() && propertyFileName.contains(BootstrapUtils.FILE_SEPARATOR)) {
                    propertyFileName = propertyFileName.substring(propertyFileName.lastIndexOf(BootstrapUtils.FILE_SEPARATOR) + 1);
                    propertyFile = new File(dir.getResouceDirectoryPath(), propertyFileName);
                }
                if (!propertyFile.exists()) continue;
                try (FileInputStream in = new FileInputStream(propertyFile);){
                    ResourcesTreeProperties parent = props;
                    props = new ResourcesTreeProperties(propertyFileName, dir.getResouceDirectoryPath(), parent);
                    props.load(in);
                    if (!Bootstrap.verbose() || Bootstrap.isQuiet()) continue;
                    System.out.println("*** Adding Properties " + dir.getResouceDirectoryPath() + propertyFileName + " to properties chain");
                    continue;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
        return props;
    }

    static void printProperties(Properties props) {
        ResourcesUtils.printProperties(props, null, null);
    }

    static void printProperties(Properties props, StringBuilder sb, Logger logger) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (logger != null) {
            logger.log(Level.FINE, "{0}", ResourcesUtils.internalPrintProperties(props, sb));
        } else {
            System.out.println(ResourcesUtils.internalPrintProperties(props, sb));
        }
    }

    private static String internalPrintProperties(Properties props, StringBuilder sb) {
        Object p;
        sb.append("*****************\n");
        if (props instanceof ResourcesTreeProperties) {
            p = (ResourcesTreeProperties)props;
            String output = "Properties from " + ((ResourcesTreeProperties)p).getPropertyFileName();
            if (((ResourcesTreeProperties)p).getResourceDirectory() != null) {
                output = output + " in resource directory " + ((ResourcesTreeProperties)p).getResourceDirectory();
            }
            sb.append(output).append("\n");
        } else {
            sb.append("External System properties");
        }
        p = props.keySet().iterator();
        while (p.hasNext()) {
            Object key = p.next();
            sb.append("\t").append(key).append(" = ").append(props.getProperty((String)key)).append("\n");
        }
        if (props instanceof ResourcesTreeProperties && ((ResourcesTreeProperties)(p = (ResourcesTreeProperties)props)).hasParent()) {
            ResourcesUtils.internalPrintProperties(((ResourcesTreeProperties)p).getParent(), sb);
        }
        return sb.toString();
    }

    static void loadKeySetForProperties(Properties props, Set<Object> set) {
        Set<Object> propsKey = props.keySet();
        for (Object obj : propsKey) {
            if (set.contains(obj)) continue;
            set.add(obj);
        }
        if (props instanceof ResourcesTreeProperties && ((ResourcesTreeProperties)props).getParent() != null) {
            ResourcesUtils.loadKeySetForProperties(((ResourcesTreeProperties)props).getParent(), set);
        }
    }

    static InputStream getResourceFromResourceTree(ResourcesTree tree, String resourceName, Logger logger) throws FileNotFoundException {
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        for (ResourceDirectory dir : resourceList) {
            File resourceFile = new File(dir.getResouceDirectoryPath() + resourceName);
            if (!resourceFile.exists()) continue;
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Found resource " + dir.getResouceDirectoryPath() + resourceName);
            }
            if (logger != null) {
                logger.fine("Found resource " + dir.getResouceDirectoryPath() + resourceName);
            }
            return new FileInputStream(resourceFile);
        }
        return null;
    }
}

