/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tutorial;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleInputStream;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.lsst.ccs.gconsole.plugins.tutorial.TutorialPlugin;

class TutorialConsole {
    private static final Logger logger = Logger.getLogger(TutorialPlugin.class.getName());
    private final Studio studio;

    TutorialConsole(Studio studio) {
        this.studio = studio;
    }

    void createOutputConsole() {
        ConsoleService consoleService = (ConsoleService)this.studio.getLookup().lookup(ConsoleService.class);
        if (consoleService != null) {
            Console console = consoleService.createConsole("Output Console", null);
            this.sendOutputToConsole(console, consoleService);
        }
    }

    void createInputConsole() {
        ConsoleService consoleService = (ConsoleService)this.studio.getLookup().lookup(ConsoleService.class);
        if (consoleService != null) {
            Console console = consoleService.createConsole("Input Console", null);
            this.readInputFromConsole(console);
        }
    }

    void createInputOutputConsole() {
        ConsoleService consoleService = (ConsoleService)this.studio.getLookup().lookup(ConsoleService.class);
        if (consoleService != null) {
            Console console = consoleService.createConsole("Input/Output Console", null);
            this.sendOutputToConsole(console, consoleService);
            this.readInputFromConsole(console);
        }
    }

    private void sendOutputToConsole(Console console, ConsoleService consoleService) {
        ConsoleOutputStream consoleOutputStream = console.getOutputStream(null);
        final PrintWriter pw = new PrintWriter((OutputStream)consoleOutputStream, true);
        Timer timer = new Timer();
        final TimerTask timerTask = new TimerTask(){
            private int tick = 0;

            @Override
            public void run() {
                ++this.tick;
                pw.printf("tick %d\n", this.tick);
                logger.info(String.format("tick %d\n", this.tick));
            }
        };
        timer.scheduleAtFixedRate(timerTask, 1000L, 1000L);
        consoleService.getPageContextForConsole(console).addPageListener(new PageListener(){

            public void pageChanged(PageEvent pe) {
                if (pe.getID() == 4001) {
                    timerTask.cancel();
                    logger.info("Console closed, timertask canceled");
                }
            }
        });
    }

    private void readInputFromConsole(final Console console) {
        String initialPrompt = "CCS> ";
        final ConsoleInputStream inputStream = console.getInputStream(initialPrompt);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                    while ((line = in.readLine()) != null) {
                        if ("exit".equals(line)) {
                            console.close();
                        } else if (line.startsWith("setPrompt")) {
                            newPrompt = line.substring(10);
                            inputStream.setOneTimePrompt(newPrompt);
                        } else if (line.startsWith("changePrompt")) {
                            newPrompt = line.substring(13);
                            inputStream.setPrompt(newPrompt);
                        }
                        logger.log(Level.INFO, "Read line: {0}", line);
                    }
                    logger.info("Exiting since console has been closed");
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Error reading from console", ex);
                }
            }
        };
        thread.start();
    }
}

