/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Store;

public class Catalog {
    private final Store store;

    Catalog(Store store) {
        this.store = store;
    }

    public Folder find(String folderName) throws DAQException {
        try {
            this.store.findFolder(folderName);
            return new Folder(this.store, folderName);
        }
        catch (DAQException x) {
            if (x.rc() == 1) {
                return null;
            }
            throw x;
        }
    }

    public List<Folder> list() throws DAQException {
        ArrayList<Folder> result = new ArrayList<Folder>();
        List<String> folderNames = this.store.listFolders();
        folderNames.forEach(name -> result.add(new Folder(this.store, (String)name)));
        return result;
    }

    public Folder insert(String folderName) throws CatalogException, DAQException {
        int rc = this.store.insertFolder(folderName);
        if (rc != 0) {
            throw new CatalogException("Error creating folder", folderName, rc);
        }
        return new Folder(this.store, folderName);
    }

    public void remove(String folderName) throws CatalogException, DAQException {
        int rc = this.store.removeFolder(folderName);
        if (rc != 0) {
            throw new CatalogException("Error creating folder", folderName, rc);
        }
    }

    public static class CatalogException
    extends DAQException {
        CatalogException(String message, String folderName, int rc) {
            super(String.format("%s: %s", message, folderName), rc);
        }
    }
}

