/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.PdfFitter;
import java.util.Random;

public class SimultaneousUnbinnedFit {
    public static void main(String[] args) {
        double x;
        int i;
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        ICloud1D c1 = histogramFactory.createCloud1D("c1");
        ICloud1D c2 = histogramFactory.createCloud1D("c2");
        IHistogram1D h1 = histogramFactory.createHistogram1D("h1", 50, -10.0, 10.0);
        IHistogram1D h2 = histogramFactory.createHistogram1D("h2", 50, -10.0, 10.0);
        Random r = new Random();
        for (i = 0; i < 100000; ++i) {
            x = r.nextGaussian();
            c1.fill(x);
            h1.fill(x);
        }
        for (i = 0; i < 100; ++i) {
            x = 3.0 + r.nextGaussian();
            c2.fill(x);
            h2.fill(x);
        }
        double h1Norm = h1.sumBinHeights() * (h1.axis().upperEdge() - h1.axis().lowerEdge()) / (double)h1.axis().bins();
        h1.scale(1.0 / h1Norm);
        double h2Norm = h2.sumBinHeights() * (h2.axis().upperEdge() - h2.axis().lowerEdge()) / (double)h2.axis().bins();
        h2.scale(1.0 / h2Norm);
        Parameter mean1 = new Parameter("mean1", 0.0, 0.1);
        Parameter mean2 = new Parameter("mean2", 3.0, 0.1);
        Parameter sigma1 = new Parameter("sigma1", 1.0, 0.1);
        Parameter sigma2 = new Parameter("sigma2", 1.0, 0.1);
        Dependent x2 = new Dependent("x", c1.lowerEdge(), c1.upperEdge());
        Gaussian g1 = new Gaussian("g1", x2, mean1, sigma1);
        Gaussian g2 = new Gaussian("g2", x2, mean2, sigma2);
        g1.getNormalizationParameter().setValue(h1.maxBinHeight());
        g2.getNormalizationParameter().setValue(h2.maxBinHeight());
        Parameter mean1Sim = new Parameter("mean1Sim", 0.0, 0.1);
        Parameter mean2Sim = new Parameter("mean2Sim", 3.0, 0.1);
        Parameter sigma1Sim = new Parameter("sigma1Sim", 1.0, 0.1);
        Gaussian g1Sim = new Gaussian("g1Sim", x2, mean1Sim, sigma1Sim);
        Gaussian g2Sim = new Gaussian("g2Sim", x2, mean2Sim, sigma1Sim);
        plotter.createRegions(2, 2);
        plotter.region(0).plot((IBaseHistogram)h1);
        plotter.region(2).plot((IBaseHistogram)h2);
        plotter.region(1).plot((IBaseHistogram)h1);
        plotter.region(3).plot((IBaseHistogram)h2);
        PdfFitter fitter = new PdfFitter("uml", "minuit");
        fitter.fit(c1, (Function)g1);
        fitter.fit(c2, (Function)g2);
        fitter.fit(new Object[]{c1, c2}, new Function[]{g1Sim, g2Sim});
        plotter.region(0).plot((IFunction)g1);
        plotter.region(2).plot((IFunction)g2);
        plotter.region(1).plot((IFunction)g1Sim);
        plotter.region(3).plot((IFunction)g2Sim);
        plotter.show();
    }
}

