/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.xmlio;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.ProgressMeter;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.xmlio.XMLIOAdapter;
import org.freehep.jas.plugin.xmlio.XMLIOPluginPrefsDialog;
import org.freehep.jas.plugin.xmlio.XMLPluginIO;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.jas.services.ProgressMeterProvider;
import org.freehep.swing.ExtensionFileFilter;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOManager;
import org.freehep.xml.io.XMLIOProxy;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class XMLIOPlugin
extends Plugin
implements PreferencesTopic {
    private Studio app;
    private XMLIOManager xmlioManager;
    private FreeHEPLookup lookup;
    private ArrayList xmlioPlugins = new ArrayList();
    private ArrayList xmlioHelpers = new ArrayList();
    private ArrayList adapters = new ArrayList();
    private AdapterComparator comparator = new AdapterComparator();
    private ProgressMeterProvider progressMeterProvider;
    private ProgressMeter meter;
    private Properties userProperties;
    private FileFilter fileFilter = new ExtensionFileFilter("xml");
    private XMLIOCommands xmlioCommands;
    private boolean wasSuccessful = true;
    private static final String XMLIOPLUGIN_DEFAULT_FILE = "org.freehep.jas.extension.xmlioplugin.DefaultFile";
    private static final String XMLIOPLUGIN_LAST_FILE = "org.freehep.jas.extension.xmlioplugin.LastFile";
    private static final String XMLIOPLUGIN_RESTORE_AT_START = "org.freehep.jas.extension.xmlioplugin.RestoreAtStart";
    private static final String XMLIOPLUGIN_SAVE_AT_EXIT = "org.freehep.jas.extension.xmlioplugin.SaveAtExit";

    protected void init() throws SAXException, IOException {
        this.app = this.getApplication();
        this.userProperties = this.app.getUserProperties();
        this.lookup = this.app.getLookup();
        this.lookup.add((Object)this);
        XMLMenuBuilder builder = this.app.getXMLMenuBuilder();
        URL xml = this.getClass().getResource("XMLIOPlugin.menus");
        builder.build(xml);
        this.xmlioCommands = new XMLIOCommands(this);
        this.getApplication().getCommandTargetManager().add((CommandGroup)this.xmlioCommands);
        this.lookup.add((Object)new ObjectFactoryAndProxy(this));
        this.progressMeterProvider = (ProgressMeterProvider)this.lookup.lookup(ProgressMeterProvider.class);
    }

    public void restoreAtStart() {
        if (this.getRestoreAtStart()) {
            this.xmlioCommands.onXMLIORestoreConfiguration();
        }
    }

    public boolean saveAtExit() {
        if (this.getSaveAtExit()) {
            this.xmlioCommands.onXMLIOSaveConfiguration();
        }
        return this.wasSuccessful;
    }

    private void loadXMLIOPlugins() {
        Lookup.Result result = this.lookup.lookup(new Lookup.Template(XMLPluginIO.class));
        for (XMLPluginIO xmlPluginIO : result.allInstances()) {
            XMLIOAdapter adapter = new XMLIOAdapter(xmlPluginIO);
            this.xmlioPlugins.add(xmlPluginIO);
            this.adapters.add(adapter);
            this.xmlioManager.getXMLIORegistry().register((Object)adapter);
        }
        Lookup.Result fResult = this.lookup.lookup(new Lookup.Template(XMLIOFactory.class));
        Iterator factories = fResult.allInstances().iterator();
        while (factories.hasNext()) {
            this.xmlioHelpers.add(factories.next());
        }
        Lookup.Result pResult = this.lookup.lookup(new Lookup.Template(XMLIOProxy.class));
        for (Object obj : pResult.allInstances()) {
            if (this.xmlioHelpers.contains(obj)) continue;
            this.xmlioHelpers.add(obj);
        }
        for (int i = 0; i < this.xmlioHelpers.size(); ++i) {
            this.xmlioManager.getXMLIORegistry().register(this.xmlioHelpers.get(i));
        }
    }

    private void clear() {
        this.xmlioPlugins.clear();
        this.adapters.clear();
        this.xmlioHelpers.clear();
        this.xmlioManager = null;
        this.wasSuccessful = true;
    }

    private void startShowProgress() {
        this.meter = this.progressMeterProvider.getProgressMeter();
        this.meter.setShowStopButton(false);
        this.meter.setVisible(true);
        this.meter.setModel((BoundedRangeModel)new MyBoundedRangeModel());
    }

    private boolean restoreNextLevel() {
        Collections.sort(this.adapters, this.comparator);
        this.meter.getModel().setValue((int)(100.0 * (1.0 - 1.0 * (double)this.adapters.size() / (1.0 * (double)this.xmlioPlugins.size()))));
        if (this.adapters.size() == 0) {
            if (!this.wasSuccessful) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog((Component)XMLIOPlugin.this.app, "There was a problem restoring the configuration. The restored state might be incomplete.", "Error", 0);
                    }
                });
            }
            return false;
        }
        XMLIOAdapter adapter = (XMLIOAdapter)this.adapters.get(0);
        int level = adapter.level();
        if (level != -1) {
            EmptyRun run = new EmptyRun(adapter);
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.wasSuccessful = false;
                this.adapters.remove(adapter);
            }
        } else {
            this.adapters.remove(adapter);
        }
        return true;
    }

    protected String chooseFile(File oldFile, String buttonText) {
        File file;
        int result;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(oldFile);
        fileChooser.setSelectedFile(oldFile);
        fileChooser.setFileFilter(this.fileFilter);
        fileChooser.setApproveButtonText(buttonText);
        int n = result = buttonText.equals("Restore") ? fileChooser.showOpenDialog((Component)this.app) : fileChooser.showSaveDialog((Component)this.app);
        if (result == 0 && (file = fileChooser.getSelectedFile()) != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    @Override
    public boolean apply(JComponent panel) {
        ((XMLIOPluginPrefsDialog)panel).apply(this);
        return true;
    }

    @Override
    public JComponent component() {
        return new XMLIOPluginPrefsDialog(this);
    }

    @Override
    public String[] path() {
        return new String[]{"Save/Restore"};
    }

    protected String getDefaultFile() {
        return PropertyUtilities.getString((Properties)this.userProperties, (String)XMLIOPLUGIN_DEFAULT_FILE, (String)(System.getProperty("user.home") + "/.JAS3/JAS3Configuration.xml"));
    }

    protected void setDefaultFile(String defaultFile) {
        this.userProperties.setProperty(XMLIOPLUGIN_DEFAULT_FILE, defaultFile);
    }

    protected String getLastFile() {
        return PropertyUtilities.getString((Properties)this.userProperties, (String)XMLIOPLUGIN_LAST_FILE, (String)(System.getProperty("user.home") + "/.JAS3/JAS3Configuration.xml"));
    }

    protected void setLastFile(String lastFile) {
        this.userProperties.setProperty(XMLIOPLUGIN_LAST_FILE, lastFile);
    }

    protected boolean getRestoreAtStart() {
        return PropertyUtilities.getBoolean((Properties)this.userProperties, (String)XMLIOPLUGIN_RESTORE_AT_START, (boolean)false);
    }

    protected void setRestoreAtStart(boolean restoreAtStart) {
        this.userProperties.setProperty(XMLIOPLUGIN_RESTORE_AT_START, Boolean.toString(restoreAtStart));
    }

    protected boolean getSaveAtExit() {
        return PropertyUtilities.getBoolean((Properties)this.userProperties, (String)XMLIOPLUGIN_SAVE_AT_EXIT, (boolean)false);
    }

    protected void setSaveAtExit(boolean saveAtExit) {
        this.userProperties.setProperty(XMLIOPLUGIN_SAVE_AT_EXIT, Boolean.toString(saveAtExit));
    }

    private class AdapterComparator
    implements Comparator {
        private AdapterComparator() {
        }

        public int compare(Object o1, Object o2) {
            XMLIOAdapter adapter1 = (XMLIOAdapter)o1;
            XMLIOAdapter adapter2 = (XMLIOAdapter)o2;
            if (adapter1.level() > adapter2.level()) {
                return 1;
            }
            if (adapter1.level() == adapter2.level()) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }

    public class XMLIOCommands
    extends CommandProcessor {
        private XMLIOPlugin thePlugin;

        public XMLIOCommands(XMLIOPlugin thePlugin) {
            this.thePlugin = thePlugin;
        }

        public void onXMLIOSaveConfiguration() {
            this.saveConfiguration(XMLIOPlugin.this.getDefaultFile());
        }

        public void onXMLIOSaveConfigurationAs() {
            String fileName = this.thePlugin.chooseFile(new File(XMLIOPlugin.this.getLastFile()), "Save");
            if (fileName != null) {
                XMLIOPlugin.this.setLastFile(fileName);
                this.saveConfiguration(fileName);
            }
        }

        public void onXMLIORestoreConfiguration() {
            this.restoreConfiguration(XMLIOPlugin.this.getDefaultFile());
        }

        public void onXMLIORestoreConfigurationFrom() {
            String fileName = this.thePlugin.chooseFile(new File(XMLIOPlugin.this.getLastFile()), "Restore");
            if (fileName != null) {
                XMLIOPlugin.this.setLastFile(fileName);
                this.restoreConfiguration(fileName);
            }
        }

        public void enableXMLIOSaveConfiguration(CommandState state) {
            state.setEnabled(true);
        }

        public void enableXMLIOSaveConfigurationAs(CommandState state) {
            state.setEnabled(true);
        }

        public void enableXMLIORestoreConfiguration(CommandState state) {
            state.setEnabled(true);
        }

        public void enableXMLIORestoreConfigurationFrom(CommandState state) {
            state.setEnabled(true);
        }

        private void saveConfiguration(String outputFileName) {
            XMLIOPlugin.this.clear();
            XMLIOPlugin.this.xmlioManager = new XMLIOManager(outputFileName);
            XMLIOPlugin.this.loadXMLIOPlugins();
            Element rootEl = new Element("JAS3Configuration");
            rootEl.setAttribute("version", XMLIOPlugin.this.app.getAppProperties().getProperty("version"));
            try {
                for (int i = 0; i < XMLIOPlugin.this.xmlioPlugins.size(); ++i) {
                    Object obj = XMLIOPlugin.this.xmlioPlugins.get(i);
                    rootEl.addContent((Content)XMLIOPlugin.this.xmlioManager.save(XMLIOPlugin.this.xmlioPlugins.get(i)));
                }
                Element pageManagerEl = new Element("PageManager");
                rootEl.addContent((Content)XMLIOPlugin.this.xmlioManager.saveAs((Object)XMLIOPlugin.this.app.getPageManager(), PageManager.class));
            }
            catch (Throwable t) {
                t.printStackTrace();
                XMLIOPlugin.this.wasSuccessful = false;
                return;
            }
            try {
                XMLIOPlugin.this.xmlioManager.getXMLIOStreamManager().saveRootElement(rootEl);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                XMLIOPlugin.this.wasSuccessful = false;
            }
            if (!XMLIOPlugin.this.wasSuccessful) {
                JOptionPane.showMessageDialog((Component)XMLIOPlugin.this.app, "There was an error saving the configuration.", "Error", 0);
            }
        }

        private void restoreConfiguration(String outputFileName) {
            XMLIOPlugin.this.clear();
            XMLIOPlugin.this.xmlioManager = new XMLIOManager(outputFileName);
            XMLIOPlugin.this.startShowProgress();
            Thread waitThread = new Thread(){

                @Override
                public void run() {
                    XMLIOPlugin.this.loadXMLIOPlugins();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                XMLIOPlugin.this.xmlioManager.restoreFromXML();
                            }
                        });
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        XMLIOPlugin.this.wasSuccessful = false;
                    }
                    while (XMLIOPlugin.this.restoreNextLevel()) {
                    }
                }
            };
            waitThread.start();
        }
    }

    private class ObjectFactoryAndProxy
    implements XMLIOFactory,
    XMLIOProxy {
        private XMLIOPlugin thePlugin;
        private Class[] classes = new Class[]{PageManager.class};

        public ObjectFactoryAndProxy(XMLIOPlugin thePlugin) {
            this.thePlugin = thePlugin;
        }

        public Class[] XMLIOFactoryClasses() {
            return this.classes;
        }

        public Class[] XMLIOProxyClasses() {
            return this.classes;
        }

        public Object createObject(Class objClass) throws IllegalArgumentException {
            if (objClass == PageManager.class) {
                return this.thePlugin.getApplication().getPageManager();
            }
            throw new IllegalArgumentException();
        }

        public void restore(Object obj, XMLIOManager xmlioManager, Element nodeEl) throws IllegalArgumentException {
        }

        public void save(Object obj, XMLIOManager xmlioManager, Element nodeEl) throws IllegalArgumentException {
            List pages = this.thePlugin.getApplication().getPageManager().pages();
            for (int i = 0; i < pages.size(); ++i) {
                PageContext page = (PageContext)pages.get(i);
                Element pageEl = new Element("Page");
                pageEl.setAttribute("name", page.getTitle());
                nodeEl.addContent((Content)pageEl);
            }
        }
    }

    private class MyBoundedRangeModel
    extends DefaultBoundedRangeModel {
        private MyBoundedRangeModel() {
        }

        @Override
        public void setValue(int value) {
            super.setValue(value);
            if (value == 100) {
                XMLIOPlugin.this.meter.setVisible(false);
                XMLIOPlugin.this.progressMeterProvider.freeProgressMeter(XMLIOPlugin.this.meter);
            }
        }
    }

    private class EmptyRun
    implements Runnable {
        private XMLIOAdapter adapter;

        public EmptyRun(XMLIOAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public void run() {
            this.adapter.restoreNextLevel();
        }
    }
}

