/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.lsst.ccs.daq.ims.channel.FitsWriteChannel;
import org.lsst.ccs.utilities.image.FitsFileWriter;

public class FitsAsyncWriteChannel
extends FitsWriteChannel {
    private static final int NBUFFERS = 2;
    private BlockingQueue<ByteBuffer> availableBuffers;
    private BlockingQueue<Throwable> exceptions;

    public FitsAsyncWriteChannel(FitsFileWriter writer, String segment) throws IOException {
        super(writer, segment);
    }

    @Override
    void initBuffers() throws IOException {
        this.availableBuffers = new ArrayBlockingQueue<ByteBuffer>(2);
        this.exceptions = new LinkedBlockingQueue<Throwable>();
        for (int n = 0; n < 2; ++n) {
            ByteBuffer bb = this.cache.allocateDirect(500000);
            bb.order(ByteOrder.BIG_ENDIAN);
            this.availableBuffers.add(bb);
        }
        this.currentBuffer = this.waitForBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            this.flush();
            this.availableBuffers.offer(this.currentBuffer);
            while (this.availableBuffers.size() < 2) {
                this.availableBuffers.offer(this.waitForBuffer());
            }
            for (int i = 0; i < 2; ++i) {
                this.cache.free((ByteBuffer)this.availableBuffers.remove());
            }
        }
    }

    @Override
    void flush() throws IOException {
        this.currentBuffer.flip();
        this.writer.asyncWrite(this.segment, this.currentBuffer, (Object)this.currentBuffer, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                FitsAsyncWriteChannel.this.availableBuffers.offer(attachment);
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                FitsAsyncWriteChannel.this.exceptions.add(exc);
                FitsAsyncWriteChannel.this.availableBuffers.offer(attachment);
            }
        });
        this.currentBuffer = this.waitForBuffer();
        this.currentBuffer.clear();
    }

    private ByteBuffer waitForBuffer() throws IOException {
        try {
            ByteBuffer bb = this.availableBuffers.take();
            this.handleException();
            return bb;
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException("Unexpected interrupt during IO");
        }
    }

    private void handleException() throws IOException {
        Throwable t = (Throwable)this.exceptions.peek();
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t != null) {
            throw new IOException("Unexpected exception during IO", t);
        }
    }
}

