/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.dataselection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PlotPage;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.DataType;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.DataTypeDialog;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.PresetList;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.PresetsDialog;

public final class DataTypeSelector
extends JComboBox {
    private final String CHOOSE_BUTTON = "Choose...";
    private final String PRESETS_BUTTON = "From Saved...";
    private final String PLOT_BUTTON = "From Plot";
    private final int MAX_PRESETS = 10;
    private final PresetList presetList;
    private volatile DataType selection;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    public DataTypeSelector(Studio application, DataType seed) {
        this.presetList = new PresetList(application);
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setMaximumRowCount(16);
        Model model = new Model(this.presetList);
        this.setModel(model);
        this.setSelectedDataType(seed);
        this.selection = model.getSelectedItem();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataType ts = DataTypeSelector.this.myModel().getSelectedItem();
                switch (ts.getName()) {
                    case "Choose...": {
                        ts = DataTypeDialog.defineDataType(DataTypeSelector.this, DataTypeSelector.this.selection);
                        if (ts == null) {
                            DataTypeSelector.this.setSelectedItem(DataTypeSelector.this.selection);
                            break;
                        }
                        ts = DataTypeSelector.this.presetList.insert(ts);
                        Model model = new Model(DataTypeSelector.this.presetList);
                        model.setSelectedItem(ts);
                        DataTypeSelector.this.setModel(model);
                        DataTypeSelector.this.setSelection(ts);
                        break;
                    }
                    case "From Saved...": {
                        ts = PresetsDialog.managePresets(DataTypeSelector.this, DataTypeSelector.this.presetList);
                        if (ts == null) {
                            ts = DataTypeSelector.this.selection;
                        }
                        ts.touch();
                        Model model = new Model(DataTypeSelector.this.presetList);
                        int index = model.getIndexOf(ts);
                        if (index == -1) {
                            index = 1;
                        }
                        DataTypeSelector.this.setSelection((DataType)model.getElementAt(index));
                        model.setSelectedItem(DataTypeSelector.this.selection);
                        DataTypeSelector.this.setModel(model);
                        break;
                    }
                    case "From Plot": {
                        try {
                            PlotPage page = LsstTrendingPlugin.getSelectedPage();
                            TrendPlotter plot = (TrendPlotter)page.currentRegion().currentPlot();
                            ts = DataTypeSelector.this.presetList.insert(plot.getDataType());
                            Model model = new Model(DataTypeSelector.this.presetList);
                            model.setSelectedItem(ts);
                            DataTypeSelector.this.setModel(model);
                            DataTypeSelector.this.setSelection(ts);
                        }
                        catch (Exception x) {
                            Console.getConsole().error("There is no currently selected plot.");
                            DataTypeSelector.this.setSelectedItem(DataTypeSelector.this.selection);
                        }
                        break;
                    }
                    default: {
                        ts.touch();
                        DataTypeSelector.this.setSelection(ts);
                    }
                }
            }
        });
    }

    public DataType getSelectedDataType() {
        return this.selection;
    }

    public void setSelectedDataType(DataType type) {
        if (type == null) {
            this.myModel().setSelectedItem(DataType.DEFAULT);
            this.setSelection(DataType.DEFAULT);
        } else {
            type = this.presetList.insert(type);
            int i = this.myModel().getIndexOf(type);
            if (i >= 0) {
                this.myModel().setSelectedItem(type);
            } else {
                type.touch();
                Model model = new Model(this.presetList);
                model.setSelectedItem(type);
                this.setModel(model);
            }
            this.setSelection(type);
        }
    }

    public PresetList getPresetList() {
        return this.presetList;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    private void setSelection(DataType type) {
        if (!Objects.equals(this.selection, type)) {
            this.selection = type;
            Event event = new Event(this, this.selection);
            this.listeners.forEach(listener -> listener.selectionChanged(event));
        }
    }

    private Model myModel() {
        return (Model)super.getModel();
    }

    private class Renderer
    implements ListCellRenderer {
        private final ListCellRenderer horse;
        private final JPanel separatorPanel = new JPanel(new BorderLayout());
        private final JSeparator separator = new JSeparator();

        Renderer(ListCellRenderer renderer) {
            this.horse = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.horse.getListCellRendererComponent(list, ((DataType)value).getName(), index, isSelected, cellHasFocus);
            if (index == 0 || index == 2 || index == DataTypeSelector.this.getItemCount() - 3) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "South");
                comp = this.separatorPanel;
            }
            return comp;
        }
    }

    private class Model
    extends DefaultComboBoxModel<DataType> {
        Model(PresetList tsList) {
            this.addElement(new DataType("Choose...", false, 0, false));
            this.addElement(DataType.RAW);
            this.addElement(DataType.DEFAULT);
            List<DataType> customRanges = tsList.getRecent(10);
            for (DataType ts : customRanges) {
                this.addElement(ts);
            }
            this.addElement(new DataType("From Plot", false, 0, false));
            this.addElement(new DataType("From Saved...", false, 0, false));
        }

        @Override
        public DataType getSelectedItem() {
            return (DataType)super.getSelectedItem();
        }
    }

    public static class Event
    extends EventObject {
        private final DataType timeWindow;

        public Event(Object source, DataType timeWindow) {
            super(source);
            this.timeWindow = timeWindow;
        }

        public DataType getTimeWindow() {
            return this.timeWindow;
        }
    }

    public static interface Listener {
        public void selectionChanged(Event var1);
    }
}

