/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;

public interface DataPage
extends HasPopupItems {
    default public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component component, Point point) {
        menu = this.modifyPopup(menu, component, point);
        if (this instanceof JComponent) {
            final JComponent panel = (JComponent)((Object)this);
            PanelManager panMan = Console.getConsole().getPanelManager();
            boolean firstItem = true;
            Panel[] keys = new Panel[]{Panel.ON_SAVE_AS, Panel.ON_EDIT};
            String[] names = new String[]{"Save Page As...", "Edit Page..."};
            for (int i = 0; i < keys.length; ++i) {
                Object o = panMan.get((Component)panel, keys[i]);
                if (o == null) continue;
                try {
                    final Consumer task = (Consumer)o;
                    if (firstItem) {
                        firstItem = false;
                        menu.addSeparator();
                    }
                    menu.add(new AbstractAction(names[i]){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            task.accept(panel);
                        }
                    });
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return menu;
    }

    default public JPopupMenu modifyPopup(JPopupMenu menu, Component component, Point point) {
        return menu;
    }

    public static JComponent wrap(JComponent page) {
        if (page instanceof DataPage) {
            return page;
        }
        Wrapper w = new Wrapper();
        w.init(page);
        return w;
    }

    public static class Wrapper
    extends JPanel
    implements DataPage {
        Wrapper() {
            super(new BorderLayout());
        }

        void init(JComponent page) {
            this.add((Component)page, "Center");
        }
    }
}

