/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Daq4Client {
    static void loadLibrary() {
        System.loadLibrary("RebDaq4");
    }

    public static class Global
    implements GlobalClient.Impl {
        long handle;

        Global() {
            Daq4Client.loadLibrary();
            Global.initSys();
        }

        private static native void initSys();

        @Override
        public void newGlobalClient(int[] ids, String[] ifc) {
            this.handle = this.newGlobalClient1(ifc[0]);
        }

        @Override
        public void newGlobalClient(String part) {
            this.handle = this.newGlobalClient1(part);
        }

        private native long newGlobalClient1(String var1);

        @Override
        public void deleteGlobalClient() {
            this.deleteGlobalClient1(this.handle);
            this.handle = 0L;
        }

        private native void deleteGlobalClient1(long var1);

        @Override
        public int getHwType() {
            return 5;
        }

        @Override
        public void setRegisterList(int rebType, int[] registers) {
            this.setRegisterList1(this.handle, rebType, registers);
        }

        private native void setRegisterList1(long var1, int var3, int[] var4);

        @Override
        public long triggerImage(String name) {
            return this.triggerImage(name, "", 1, "", new int[0]);
        }

        @Override
        public long triggerImage(String name, String folder, int opcode, String annotation, int ... ids) {
            return this.triggerImage1(this.handle, name, folder, opcode, annotation, ids);
        }

        private native long triggerImage1(long var1, String var3, String var4, int var5, String var6, int ... var7);

        @Override
        public long startSequencer(int opcode) {
            return this.startSequencer1(this.handle, opcode);
        }

        private native long startSequencer1(long var1, int var3);

        private native void setRebs1(long var1, int[] var3);

        private native void addRebs1(long var1, int[] var3);

        private native void removeRebs1(long var1, int[] var3);

        private native void resetRebs1(long var1);
    }

    public static class Images
    implements ImageClient.Impl {
        long handle;

        Images() {
            Daq4Client.loadLibrary();
            Images.initSys();
        }

        private static native void initSys();

        @Override
        public native void newImageClient(int var1, String var2);

        @Override
        public native void deleteImageClient();

        @Override
        public native Image waitForImage(Image var1);

        @Override
        public native boolean getImage(Image var1);

        @Override
        public native void interrupt();
    }

    public static class Registers
    implements RegClient.Impl {
        private static final int MAX_RETRY = 2;
        private static final Logger LOG = Logger.getLogger(Registers.class.getName());
        private final String path;

        Registers(String path) {
            Daq4Client.loadLibrary();
            this.path = path;
        }

        @Override
        public native long newRegClient(int var1, String var2);

        @Override
        public native void deleteRegClient(long var1);

        @Override
        public int readReg(long handle, int address) throws REBException {
            int[] values = new int[1];
            this.readRegs(handle, address, values, 0, 1);
            return values[0];
        }

        @Override
        public void readRegs(long handle, int address, int[] values, int offset, int count) throws REBException {
            long startNanos = System.nanoTime();
            for (int j = 0; j <= 2; ++j) {
                try {
                    this.readRegs1(handle, address, values, offset, count);
                    if (j > 0) {
                        int finalJ = j;
                        LOG.log(Level.WARNING, () -> String.format("%s: Reading register @%x required %d retries, and %,dns", this.path, address, finalJ, System.nanoTime() - startNanos));
                    }
                    return;
                }
                catch (DriverException e) {
                    if (j < 2) continue;
                    throw e;
                }
            }
        }

        public native void readRegs1(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public void writeReg(long handle, int address, int value) throws REBException {
            int[] values = new int[]{value};
            this.writeRegs(handle, address, values, 0, 1);
        }

        @Override
        public void writeRegs(long handle, int address, int[] values, int offset, int count) throws REBException {
            for (int j = 0; j <= 2; ++j) {
                try {
                    this.writeRegs1(handle, address, values, offset, count);
                    return;
                }
                catch (DriverException e) {
                    if (j < 2) continue;
                    throw e;
                }
            }
        }

        public native void writeRegs1(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public int updateReg(long handle, int address, int mask, int value) throws REBException {
            int[] values = new int[]{0};
            this.readRegs(handle, address, values, 0, 1);
            int oldVal = values[0];
            values[0] = values[0] & ~mask | value & mask;
            this.writeRegs(handle, address, values, 0, 1);
            return oldVal;
        }

        @Override
        public native void reset(long var1, int var3) throws REBException;
    }
}

