/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.DAQSourceChannelImplementation;

public class DAQSourceChannelSimulatedImplementation
extends DAQSourceChannelImplementation {
    private final SeekableByteChannel byteChannel;

    public DAQSourceChannelSimulatedImplementation(Path rawData) throws DAQException {
        try {
            this.byteChannel = Files.newByteChannel(rawData, new OpenOption[0]);
        }
        catch (IOException x) {
            throw new DAQException("Error opening rawData " + rawData);
        }
    }

    @Override
    int read(ByteBuffer dst, int position, long offset, int length) {
        try {
            this.byteChannel.position(offset);
            int position1 = dst.position();
            int limit = dst.limit();
            dst.position(position);
            dst.limit(length);
            int l = this.byteChannel.read(dst.slice());
            dst.position(position1);
            dst.limit(limit);
            return 0;
        }
        catch (IOException ex) {
            return 1;
        }
    }

    @Override
    int write(ByteBuffer src, int position, int remaining) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    void close(boolean write) {
        try {
            this.byteChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

