/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class AsciiIONet
implements AsciiIO {
    private int connTimeout;
    private Socket sock;
    private InputStream in;
    private OutputStream out;

    @Override
    public void open(String host, int port, int dummy) throws DriverException {
        try {
            this.sock = new Socket();
            this.sock.connect(new InetSocketAddress(host, port), this.connTimeout);
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void close() throws DriverException {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void write(byte[] buff, int offset, int leng) throws DriverException {
        try {
            this.out.write(buff, offset, leng);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public int read(byte[] buff, int offset, int mleng) throws DriverException {
        if (offset + mleng > buff.length) {
            mleng = buff.length - offset;
        }
        try {
            int leng = 0;
            int count = this.in.available();
            if (count == 0) {
                leng = this.in.read(buff, offset, 1);
                if (leng <= 0) {
                    throw new DriverException("Connection closed");
                }
                ++offset;
                --mleng;
                count = this.in.available();
            }
            if (count > mleng) {
                count = mleng;
            }
            if (count > 0) {
                leng += this.in.read(buff, offset, count);
            }
            return leng;
        }
        catch (SocketTimeoutException e) {
            throw new DriverTimeoutException("Read timed out");
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void flush() throws DriverException {
        try {
            this.in.skip(this.in.available());
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void setConnTimeout(int timeout) {
        this.connTimeout = timeout;
    }

    @Override
    public void setTimeout(int timeout) throws DriverException {
        try {
            this.sock.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            throw new DriverException((Throwable)e);
        }
    }
}

