/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Exponential;
import hep.aida.ref.pdf.FunctionConverter;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Product;
import hep.aida.ref.pdf.Step;
import hep.aida.ref.pdf.Sum;

public class ProductOfPdfFit {
    public static void main(String[] args) {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        ICloud1D c1 = histogramFactory.createCloud1D("Cloud 1D");
        for (int i = 0; i < 100000; ++i) {
        }
        IHistogram1D h1 = histogramFactory.createHistogram1D("Histogram 1D", 50, c1.lowerEdge(), c1.upperEdge());
        c1.fillHistogram(h1);
        Dependent x = new Dependent("x", c1.lowerEdge(), c1.upperEdge());
        Parameter m = new Parameter("mean", 0.0);
        Parameter s = new Parameter("sigma", 2.0);
        Gaussian gauss = new Gaussian("myGauss", x, m, s);
        Parameter le = new Parameter("le", c1.lowerEdge());
        Parameter ue = new Parameter("ue", c1.upperEdge());
        Parameter a = new Parameter("a", 0.5);
        Step lowerStep = new Step("lowerStep", x, le, a);
        Step upperStep = new Step("upperStep", x, a, ue);
        Parameter tau = new Parameter("tau", 0.3);
        Exponential expo = new Exponential("exp", x, tau, Exponential.DECAY);
        IModelFunction exp = FunctionConverter.getIModelFunction(expo);
        Product p1f = new Product("p1", lowerStep, gauss);
        Product p2f = new Product("p2", upperStep, expo);
        IModelFunction p1 = FunctionConverter.getIModelFunction(p1f);
        IModelFunction p2 = FunctionConverter.getIModelFunction(p2f);
        Sum ss = new Sum("total dist", p1f, p2f);
        IModelFunction sum = FunctionConverter.getIModelFunction(ss);
        IFitter fit = fitFactory.createFitter("uml", "minuit", "noClone=true");
        fit.fitParameterSettings("mean").setStepSize(0.01);
        fit.fitParameterSettings("f0").setStepSize(0.1);
        fit.fitParameterSettings("f0").setBounds(0.0, 1.0);
        fit.fitParameterSettings("le").setFixed(true);
        fit.fitParameterSettings("ue").setFixed(true);
        fit.fitParameterSettings("a").setFixed(true);
        long start = System.currentTimeMillis();
        IFitResult fitResult = fit.fit((IBaseHistogram)c1, (IFunction)p1);
        long end = System.currentTimeMillis();
        long time = end - start;
        System.out.println("Time to fit : " + time);
        double h1Norm = h1.sumBinHeights() * (h1.axis().upperEdge() - h1.axis().lowerEdge()) / (double)h1.axis().bins();
        h1.scale(1.0 / h1Norm);
        plotter.region(0).plot((IBaseHistogram)h1);
        plotter.region(0).plot(fitResult.fittedFunction());
        plotter.show();
    }
}

