/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.gconsole.agent.command.CommandCode;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.commandbrowser.LsstCommandBrowserPlugin;
import org.lsst.ccs.gconsole.services.persist.Savable;

public final class OutputPanel
extends JTextPane
implements Savable,
HasPopupItems {
    private final LsstCommandBrowserPlugin plugin = Console.getConsole().getSingleton(LsstCommandBrowserPlugin.class);
    private final LinkedList<Record> records = new LinkedList();
    private final int MAX_RECORDS = 100;
    long recordID = 0L;
    private final Style attBase;
    private final Style attPlane;
    private final Style attCom;
    private final Style attTime;
    private final Style attRed;
    private final Action actClear;
    private final Action actFontLarger;
    private final Action actFontSmaller;
    private final CommandHandle util = new CommandHandle(){};
    private Descriptor descriptor = new Descriptor();

    public OutputPanel() {
        this.setEditable(false);
        this.setCaretPosition(0);
        StyledDocument doc = this.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        this.attBase = doc.addStyle("attBase", def);
        StyleConstants.setFontSize(this.attBase, 15);
        this.attPlane = doc.addStyle("attPlane", this.attBase);
        this.attCom = doc.addStyle("attCom", this.attBase);
        StyleConstants.setFontFamily(this.attCom, "Monospaced");
        StyleConstants.setBold(this.attCom, true);
        StyleConstants.setForeground(this.attCom, new Color(0, 0, 100));
        this.attTime = doc.addStyle("attTime", this.attBase);
        StyleConstants.setForeground(this.attTime, new Color(110, 110, 110));
        this.attRed = doc.addStyle("attRed", this.attBase);
        StyleConstants.setForeground(this.attRed, Color.red);
        String name = "Clear";
        KeyStroke ks = KeyStroke.getKeyStroke(67, 512);
        this.actClear = new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyledDocument doc = OutputPanel.this.getStyledDocument();
                try {
                    doc.remove(0, doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                OutputPanel.this.records.clear();
            }
        };
        this.actClear.putValue("AcceleratorKey", ks);
        this.getInputMap(1).put(ks, name);
        this.getActionMap().put(name, this.actClear);
        name = "Larger";
        ks = KeyStroke.getKeyStroke(61, 512);
        this.actFontLarger = new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                int fs = StyleConstants.getFontSize(OutputPanel.this.attBase);
                OutputPanel.this.setFontSize(fs + 1);
            }
        };
        this.actFontLarger.putValue("AcceleratorKey", ks);
        this.getInputMap(1).put(ks, name);
        this.getActionMap().put(name, this.actFontLarger);
        name = "Smaller";
        ks = KeyStroke.getKeyStroke(45, 512);
        this.actFontSmaller = new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                int fs = StyleConstants.getFontSize(OutputPanel.this.attBase);
                if (fs > 6) {
                    OutputPanel.this.setFontSize(fs - 1);
                }
            }
        };
        this.actFontSmaller.putValue("AcceleratorKey", ks);
        this.getInputMap(1).put(ks, name);
        this.getActionMap().put(name, this.actFontSmaller);
    }

    public long addCommand(String command) {
        Record record = new Record(command);
        record.add();
        this.records.add(record);
        if (this.records.size() > 100) {
            Record r = this.records.pollFirst();
            r.remove();
        }
        this.setCaretPosition(this.getStyledDocument().getLength());
        return record.id;
    }

    public void addAck(long id) {
        Iterator<Record> it = this.records.descendingIterator();
        while (it.hasNext()) {
            Record r = it.next();
            if (r.id != id) continue;
            r.addAck();
            break;
        }
        this.setCaretPosition(this.getStyledDocument().getLength());
    }

    public void addResponse(long id, CommandCode code, Object response) {
        Iterator<Record> it = this.records.descendingIterator();
        while (it.hasNext()) {
            Record r = it.next();
            if (r.id != id) continue;
            r.addResponse(code, response);
            break;
        }
        this.setCaretPosition(this.getStyledDocument().getLength());
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component cmpnt, Point point) {
        menu.add(new JMenuItem(this.actClear));
        JMenu fontMenu = new JMenu("Font size");
        menu.add(fontMenu);
        fontMenu.add(new JMenuItem(this.actFontLarger));
        fontMenu.add(new JMenuItem(this.actFontSmaller));
        return menu;
    }

    private void setFontSize(int size) {
        this.setButtonSize(this, size);
        StyleConstants.setFontSize(this.attBase, size);
        this.descriptor.setFontSize(size);
    }

    private void setButtonSize(Component comp, int size) {
        if (comp instanceof JButton) {
            comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, size));
        } else if (comp instanceof Container) {
            Component[] cc;
            for (Component c : cc = ((Container)comp).getComponents()) {
                this.setButtonSize(c, size);
            }
        }
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        } else if (descriptor == null) {
            this.descriptor = new Descriptor();
        }
        this.setFontSize(this.descriptor.getFontSize());
    }

    @Override
    public Descriptor save() {
        return this.descriptor.clone();
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private int fontSize = 15;

        public int getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(int fontSize) {
            this.fontSize = fontSize;
        }

        public Descriptor clone() {
            try {
                return (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                throw new RuntimeException();
            }
        }
    }

    public class Record {
        final long id;
        final String command;
        CommandCode code;
        Object response;
        Position posFirst;
        Position posLast;
        String timing;
        long sendTime;

        Record(String command) {
            this.id = OutputPanel.this.recordID++;
            this.command = command;
        }

        void add() {
            StyledDocument doc = OutputPanel.this.getStyledDocument();
            int i = doc.getLength();
            try {
                if (OutputPanel.this.plugin.isDisplayTiming()) {
                    this.sendTime = System.currentTimeMillis();
                    this.timing = " [ack: ... / total: ... ] ms\n";
                    doc.insertString(i, "> " + this.command + "  ", OutputPanel.this.attCom);
                    doc.insertString(doc.getLength(), this.timing, OutputPanel.this.attTime);
                } else {
                    this.sendTime = 0L;
                    this.timing = " ...\n";
                    doc.insertString(i, "> " + this.command + "  " + this.timing, OutputPanel.this.attCom);
                }
                this.posFirst = doc.createPosition(i);
                this.posLast = doc.createPosition(doc.getLength() - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        void remove() {
            try {
                int start = this.posFirst.getOffset();
                int length = this.posLast.getOffset() - start + 1;
                OutputPanel.this.getStyledDocument().remove(start, length);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        void collaps() {
            throw new UnsupportedOperationException("Not yet implemented.");
        }

        void expand() {
            throw new UnsupportedOperationException("Not yet implemented.");
        }

        void addAck() {
            if (this.sendTime > 0L) {
                StyledDocument doc = OutputPanel.this.getStyledDocument();
                try {
                    int i = this.posLast.getOffset() - this.timing.length();
                    doc.remove(i, this.timing.length());
                    long time = System.currentTimeMillis() - this.sendTime;
                    this.timing = this.timing.replace("ack: ...", "ack: " + Long.toString(time));
                    doc.insertString(this.posLast.getOffset(), this.timing, OutputPanel.this.attTime);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        void addResponse(CommandCode code, Object response) {
            this.code = code;
            this.response = response;
            StyledDocument doc = OutputPanel.this.getStyledDocument();
            try {
                int i = this.posLast.getOffset() - this.timing.length();
                doc.remove(i, this.timing.length());
                if (this.sendTime > 0L) {
                    long time = System.currentTimeMillis() - this.sendTime;
                    this.timing = this.timing.replace("... ] ms\n", Long.toString(time) + " ] ms");
                    doc.insertString(this.posLast.getOffset(), this.timing, OutputPanel.this.attTime);
                }
                this.showResponse();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void showResponse() throws BadLocationException {
            StyledDocument doc = OutputPanel.this.getStyledDocument();
            int i = this.posLast.getOffset();
            doc.insertString(i++, "\n", OutputPanel.this.attCom);
            switch (this.code) {
                case SUCCESS: {
                    if (this.response == null) {
                        doc.insertString(i, "null", OutputPanel.this.attPlane);
                        break;
                    }
                    Class<?> respClass = this.response.getClass();
                    if (respClass.isArray()) {
                        try {
                            this.response = Arrays.deepToString((Object[])this.response);
                        }
                        catch (ClassCastException x) {
                            if (respClass == byte[].class) {
                                this.response = Arrays.toString((byte[])this.response);
                            } else if (respClass == short[].class) {
                                this.response = Arrays.toString((short[])this.response);
                            } else if (respClass == int[].class) {
                                this.response = Arrays.toString((int[])this.response);
                            } else if (respClass == long[].class) {
                                this.response = Arrays.toString((long[])this.response);
                            } else if (respClass == char[].class) {
                                this.response = Arrays.toString((char[])this.response);
                            } else if (respClass == float[].class) {
                                this.response = Arrays.toString((float[])this.response);
                            } else if (respClass == double[].class) {
                                this.response = Arrays.toString((double[])this.response);
                            } else if (respClass == boolean[].class) {
                                this.response = Arrays.toString((boolean[])this.response);
                            }
                        }
                    } else if (this.response instanceof List && this.response.toString().length() > 40) {
                        StringBuilder sb = new StringBuilder("[\n    ");
                        List ss = ((List)this.response).stream().map(o -> Objects.toString(o)).collect(Collectors.toList());
                        sb.append(String.join((CharSequence)",\n    ", ss));
                        sb.append("\n]");
                        this.response = sb.toString();
                    } else if (this.response instanceof Map && this.response.toString().length() > 40) {
                        StringBuilder sb = new StringBuilder("{\n    ");
                        List ss = ((Map)this.response).entrySet().stream().map(e -> Objects.toString(e.getKey()) + "=" + Objects.toString(e.getValue())).collect(Collectors.toList());
                        sb.append(String.join((CharSequence)",\n    ", ss));
                        sb.append("\n}");
                        this.response = sb.toString();
                    } else if (this.response.equals("")) {
                        this.response = "\"\"";
                    }
                    doc.insertString(i, this.response.toString(), OutputPanel.this.attPlane);
                    break;
                }
                case SEND_FAIL: {
                    if (this.response instanceof Exception) {
                        Exception x = (Exception)this.response;
                        String message = OutputPanel.this.util.shorten(x.getMessage()) + " ";
                        doc.insertString(i, message, OutputPanel.this.attRed);
                        this.insertButton(i + message.length(), x.getMessage(), x);
                        break;
                    }
                    doc.insertString(i, "Could not send the command: " + this.response, OutputPanel.this.attRed);
                    break;
                }
                case NACK: {
                    StringBuilder sb = new StringBuilder("Command rejected");
                    if (this.response instanceof CommandNack) {
                        CommandNack nack = (CommandNack)this.response;
                        String message = OutputPanel.this.util.shorten(nack.getReason());
                        if (message != null && !message.isEmpty()) {
                            sb.append(": ").append(message);
                        }
                    }
                    doc.insertString(i, sb.toString(), OutputPanel.this.attRed);
                    break;
                }
                case TIMEOUT: {
                    doc.insertString(i, OutputPanel.this.util.shorten(((TimeoutException)this.response).getMessage()), OutputPanel.this.attRed);
                    break;
                }
                case CANCEL: {
                    doc.insertString(i, "Cancelled.", OutputPanel.this.attRed);
                    break;
                }
                case EXEC_FAIL: {
                    if (this.response instanceof Exception) {
                        Exception x = (Exception)this.response;
                        String message = OutputPanel.this.util.shorten(x.getMessage()) + " ";
                        doc.insertString(i, message, OutputPanel.this.attRed);
                        this.insertButton(i + message.length(), x.getMessage(), x);
                        break;
                    }
                    doc.insertString(i, "Command execution failed.", OutputPanel.this.attRed);
                }
            }
        }

        private void insertButton(int offset, String message, Exception exception) throws BadLocationException {
            SimpleAttributeSet attButton = new SimpleAttributeSet(OutputPanel.this.attBase);
            StyleConstants.setAlignment(attButton, 1);
            JButton button = new JButton(" ");
            button.setToolTipText("More information ...");
            button.setPreferredSize(new Dimension(button.getPreferredSize().width, StyleConstants.getFontSize(OutputPanel.this.attBase)));
            button.setAlignmentY(0.8f);
            button.setCursor(Cursor.getPredefinedCursor(12));
            button.setMargin(new Insets(0, 0, 0, 0));
            button.addActionListener(e -> {
                StringBuilder sb = new StringBuilder("Command:\n");
                sb.append(this.command).append("\n");
                sb.append("failed during execution.\n\n");
                if (message != null) {
                    sb.append(message);
                }
                Console.getConsole().error(sb.toString(), exception);
            });
            StyleConstants.setComponent(attButton, button);
            StyledDocument doc = OutputPanel.this.getStyledDocument();
            doc.insertString(offset, " ", attButton);
        }
    }
}

