/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.AllDataDisposedTopicStatusHolder;
import DDS.DataReader;
import DDS.DataReaderView;
import DDS.DataWriter;
import DDS.DomainParticipant;
import DDS.ExtTopicListener;
import DDS.InconsistentTopicStatus;
import DDS.InconsistentTopicStatusHolder;
import DDS.TOPIC_QOS_DEFAULT;
import DDS.Topic;
import DDS.TopicListener;
import DDS.TopicQos;
import DDS.TopicQosHolder;
import java.util.Map;
import org.opensplice.dds.dcps.DomainParticipantImpl;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.TopicBase;
import org.opensplice.dds.dcps.TopicDescription;
import org.opensplice.dds.dcps.TypeSupportImpl;
import org.opensplice.dds.dcps.Utilities;

public class TopicImpl
extends TopicBase
implements Topic,
TopicDescription {
    private static final long serialVersionUID = -4295358388686624149L;
    private String name = null;
    private DomainParticipantImpl participant = null;
    private TypeSupportImpl typeSupport = null;
    private TopicListener listener = null;
    private int refCount = 0;
    private String type_name = null;
    private int topicListenerInterest = 0;
    private int participantListenerInterest = 0;

    protected int init(DomainParticipantImpl participant, String topic_name, String type_name, TopicQos a_qos) {
        int result = 0;
        TypeSupportImpl type_support = participant.lookup_typeSupport(type_name);
        if (type_support != null) {
            long uParticipant = participant.get_user_object();
            if (uParticipant != 0L) {
                String key_list = type_support.get_key_list();
                String actual_type_name = type_support.get_internal_type_name();
                long uTopic = this.jniTopicNew(uParticipant, topic_name, actual_type_name, key_list, a_qos);
                if (uTopic != 0L) {
                    this.name = topic_name;
                    this.type_name = type_name;
                    this.typeSupport = type_support;
                    this.participant = participant;
                    this.set_user_object(uTopic);
                    this.setDomainId(participant.getDomainId());
                } else {
                    result = 1;
                }
            } else {
                result = 9;
            }
        } else {
            result = 3;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        long uTopic = 0L;
        TopicImpl topicImpl = this;
        synchronized (topicImpl) {
            uTopic = this.get_user_object();
            if (uTopic != 0L) {
                if (this.refCount == 0) {
                    if (this.listener != null) {
                        result = this.set_listener(this.listener, 0);
                    }
                    if (result == 0 && (result = this.disable_callbacks()) == 0 && (result = this.detach_statuscondition()) == 0) {
                        this.typeSupport = null;
                        this.name = null;
                        this.type_name = null;
                        this.participant = null;
                        result = this.jniTopicFree(uTopic);
                        if (result == 0) {
                            result = super.deinit();
                        }
                    }
                } else {
                    result = 4;
                    ReportStack.report(result, "Topic '" + this.name + "' still referenced " + this.refCount + " times.");
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int keep() {
        int result = 0;
        ReportStack.start();
        TopicImpl topicImpl = this;
        synchronized (topicImpl) {
            long uTopic = this.get_user_object();
            if (uTopic != 0L) {
                ++this.refCount;
                result = 0;
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int free() {
        int result = 0;
        ReportStack.start();
        TopicImpl topicImpl = this;
        synchronized (topicImpl) {
            long uTopic = this.get_user_object();
            if (uTopic != 0L) {
                --this.refCount;
                result = 0;
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int clone(long uTopic, DomainParticipantImpl dp, TypeSupportImpl type_support) {
        int result = 0;
        assert (uTopic != 0L);
        assert (dp != null);
        TopicImpl topicImpl = this;
        synchronized (topicImpl) {
            this.set_user_object(uTopic);
            this.name = this.jniGetName(uTopic);
            this.participant = dp;
            this.setDomainId(dp.getDomainId());
            this.typeSupport = null;
            if (type_support != null) {
                this.typeSupport = type_support;
            } else {
                String typename = this.jniGetTypeName(uTopic);
                this.typeSupport = this.participant.lookup_typeSupport(typename);
                if (this.typeSupport == null) {
                    Map<String, TypeSupportImpl> ts = this.participant.get_typesupports();
                    for (Map.Entry<String, TypeSupportImpl> tsp : ts.entrySet()) {
                        if (!tsp.getValue().get_type_name().equals(typename)) continue;
                        this.typeSupport = tsp.getValue();
                        break;
                    }
                }
                if (this.typeSupport != null) {
                    String typeKeyList = this.typeSupport.get_key_list();
                    String topicKeyList = this.jniGetKeyExpr(uTopic);
                    if (typeKeyList == null || topicKeyList == null) {
                        if (typeKeyList == null && topicKeyList != null) {
                            ReportStack.report(0, "incompatible keys: registered typesupport has no key but topic has key '" + topicKeyList + "'.");
                        } else if (typeKeyList != null && topicKeyList == null) {
                            ReportStack.report(0, "incompatible keys: registered typesupport has key '" + typeKeyList + "' but topic has no key.");
                        }
                    } else {
                        String[] topicKeyArr;
                        boolean consistent;
                        String[] typeKeyArr = typeKeyList.split(",\\s");
                        boolean bl = consistent = typeKeyArr.length == (topicKeyArr = topicKeyList.split(",\\s")).length;
                        if (consistent) {
                            for (int i = 0; consistent && i < typeKeyArr.length; ++i) {
                                consistent = typeKeyArr[i].equals(topicKeyArr[i]);
                            }
                        }
                        if (!consistent) {
                            ReportStack.report(0, "incompatible keys: registered typesupport has key '" + typeKeyList + "' but topic has key '" + topicKeyList + "'.");
                        }
                    }
                }
            }
        }
        return result;
    }

    protected int set(TypeSupportImpl type_support) {
        int result;
        if (type_support != null) {
            this.typeSupport = type_support;
            result = 0;
        } else {
            result = 3;
        }
        return result;
    }

    protected TypeSupportImpl get_typesupport() {
        return this.typeSupport;
    }

    @Override
    public String get_type_name() {
        if (this.type_name == null && this.typeSupport != null) {
            this.type_name = this.typeSupport.get_type_name();
        }
        return this.type_name;
    }

    @Override
    public String get_name() {
        return this.name;
    }

    @Override
    public int get_inconsistent_topic_status(InconsistentTopicStatusHolder status) {
        long uTopic = 0L;
        int result = 0;
        ReportStack.start();
        uTopic = this.get_user_object();
        result = uTopic != 0L ? this.jniGetInconsistentTopicStatus(uTopic, status) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_all_data_disposed_topic_status(AllDataDisposedTopicStatusHolder status) {
        long uTopic = 0L;
        int result = 0;
        ReportStack.start();
        uTopic = this.get_user_object();
        result = uTopic != 0L ? this.jniGetAllDataDisposedTopicStatus(uTopic, status) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_qos(TopicQosHolder qos) {
        long uTopic = 0L;
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            uTopic = this.get_user_object();
            result = uTopic != 0L ? this.jniGetQos(uTopic, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_qos(TopicQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == TOPIC_QOS_DEFAULT.value) {
            TopicQosHolder holder = new TopicQosHolder();
            this.participant.get_default_topic_qos(holder);
            qos = holder.value;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            long uTopic = this.get_user_object();
            result = uTopic != 0L ? this.jniSetQos(uTopic, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public TopicListener get_listener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int set_listener(TopicListener a_listener, int mask) {
        long uTopic = 0L;
        int result = 0;
        ReportStack.start();
        TopicImpl topicImpl = this;
        synchronized (topicImpl) {
            uTopic = this.get_user_object();
            if (uTopic != 0L) {
                this.listener = a_listener;
                this.topicListenerInterest = mask;
                result = this.set_listener_interest(mask | this.participantListenerInterest);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int set_participant_listener_mask(int mask) {
        long uTopic = 0L;
        int result = 0;
        ReportStack.start();
        TopicImpl topicImpl = this;
        synchronized (topicImpl) {
            uTopic = this.get_user_object();
            if (uTopic != 0L) {
                this.participantListenerInterest = mask;
                result = this.set_listener_interest(mask | this.topicListenerInterest);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public DomainParticipant get_participant() {
        return this.participant;
    }

    @Override
    public int dispose_all_data() {
        long uTopic = 0L;
        int result = 0;
        ReportStack.start();
        uTopic = this.get_user_object();
        result = uTopic != 0L ? this.jniDisposeAllData(uTopic) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    protected DataWriter create_datawriter() {
        DataWriter writer = null;
        if (this.get_user_object() != 0L && this.typeSupport != null) {
            writer = this.typeSupport.create_datawriter();
        }
        return writer;
    }

    @Override
    public DataReader create_datareader() {
        DataReader reader = null;
        if (this.get_user_object() != 0L && this.typeSupport != null) {
            reader = this.typeSupport.create_datareader();
        }
        return reader;
    }

    @Override
    public DataReaderView create_dataview() {
        DataReaderView view = null;
        if (this.get_user_object() != 0L && this.typeSupport != null) {
            view = this.typeSupport.create_dataview();
        }
        return view;
    }

    @Override
    protected int notify(Event e) {
        int result = 0;
        TopicListener tl = this.listener;
        if (e.kind == 1) {
            if (tl != null && (this.topicListenerInterest & 1) != 0) {
                InconsistentTopicStatus status = (InconsistentTopicStatus)e.status;
                tl.on_inconsistent_topic(this, status);
            } else if ((this.participantListenerInterest & 1) != 0) {
                this.participant.notify(e);
            }
        }
        if (e.kind == Integer.MIN_VALUE) {
            if (tl != null && (this.topicListenerInterest & Integer.MIN_VALUE) != 0) {
                ExtTopicListener etl = (ExtTopicListener)this.listener;
                etl.on_all_data_disposed(this);
            } else if ((this.participantListenerInterest & Integer.MIN_VALUE) != 0) {
                this.participant.notify(e);
            }
        }
        return result;
    }

    protected int validate_filter(String _expression, String[] _parameters) {
        long uTopic = 0L;
        int result = 0;
        uTopic = this.get_user_object();
        result = uTopic != 0L ? this.jniValidateFilter(uTopic, _expression, _parameters) : 9;
        return result;
    }

    private native long jniTopicNew(long var1, String var3, String var4, String var5, TopicQos var6);

    private native int jniTopicFree(long var1);

    private native int jniGetInconsistentTopicStatus(long var1, InconsistentTopicStatusHolder var3);

    private native int jniGetAllDataDisposedTopicStatus(long var1, AllDataDisposedTopicStatusHolder var3);

    private native int jniGetQos(long var1, TopicQosHolder var3);

    private native int jniSetQos(long var1, TopicQos var3);

    private native String jniGetName(long var1);

    private native String jniGetKeyExpr(long var1);

    private native String jniGetTypeName(long var1);

    private native int jniDisposeAllData(long var1);

    private native int jniValidateFilter(long var1, String var3, String[] var4);
}

