/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DataReader;
import DDS.DataReaderView;
import DDS.ReadCondition;
import org.opensplice.dds.dcps.DataReaderImpl;
import org.opensplice.dds.dcps.DataReaderViewImpl;
import org.opensplice.dds.dcps.ReadConditionBase;
import org.opensplice.dds.dcps.ReportStack;

public class ReadConditionImpl
extends ReadConditionBase
implements ReadCondition {
    private static final long serialVersionUID = -8237808904293010400L;
    private DataReaderImpl reader;
    private DataReaderViewImpl view;
    private int sample_states;
    private int view_states;
    private int instance_states;

    protected ReadConditionImpl() {
    }

    protected int init(DataReaderImpl reader, int sample_states, int view_states, int instance_states, long uQuery) {
        int result = 3;
        if (reader != null) {
            result = 0;
            if (uQuery == 0L) {
                long uReader = reader.get_user_object();
                if (uReader != 0L) {
                    uQuery = this.jniReadConditionNew(uReader, this, sample_states, view_states, instance_states);
                } else {
                    result = 9;
                }
            }
            this.set_user_object(uQuery);
            this.reader = reader;
            this.view = null;
            this.sample_states = sample_states;
            this.view_states = view_states;
            this.instance_states = instance_states;
            this.setDomainId(reader.getDomainId());
        }
        return result;
    }

    protected int init(DataReaderViewImpl view, int sample_states, int view_states, int instance_states, long uQuery) {
        int result = 3;
        if (view != null) {
            result = 0;
            if (uQuery == 0L) {
                long uView = view.get_user_object();
                if (uView != 0L) {
                    uQuery = this.jniReadConditionNew(uView, this, sample_states, view_states, instance_states);
                } else {
                    result = 9;
                }
            }
            this.set_user_object(uQuery);
            this.reader = null;
            this.view = view;
            this.sample_states = sample_states;
            this.view_states = view_states;
            this.instance_states = instance_states;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 9;
        ReadConditionImpl readConditionImpl = this;
        synchronized (readConditionImpl) {
            long uQuery = this.get_user_object();
            if (uQuery != 0L) {
                this.reader = null;
                this.view = null;
                result = super.deinit();
                if (result == 0) {
                    result = this.jniReadConditionFree(uQuery);
                }
            }
        }
        return result;
    }

    @Override
    public boolean get_trigger_value() {
        long uQuery = 0L;
        boolean result = false;
        ReportStack.start();
        uQuery = this.get_user_object();
        if (uQuery != 0L) {
            result = this.jniGetTriggerValue(uQuery);
        }
        ReportStack.flush(this, false);
        return result;
    }

    private native boolean jniGetTriggerValue(long var1);

    @Override
    public int get_sample_state_mask() {
        return this.sample_states;
    }

    @Override
    public int get_view_state_mask() {
        return this.view_states;
    }

    @Override
    public int get_instance_state_mask() {
        return this.instance_states;
    }

    @Override
    public DataReader get_datareader() {
        return this.reader;
    }

    @Override
    public DataReaderView get_datareaderview() {
        return this.view;
    }

    private native long jniReadConditionNew(long var1, Object var3, int var4, int var5, int var6);

    private native int jniReadConditionFree(long var1);
}

