/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DATAWRITER_QOS_DEFAULT;
import DDS.DATAWRITER_QOS_USE_TOPIC_QOS;
import DDS.DataWriter;
import DDS.DataWriterListener;
import DDS.DataWriterQos;
import DDS.DataWriterQosHolder;
import DDS.DomainParticipant;
import DDS.Duration_t;
import DDS.LivelinessLostStatus;
import DDS.OfferedDeadlineMissedStatus;
import DDS.OfferedIncompatibleQosStatus;
import DDS.PUBLISHER_QOS_DEFAULT;
import DDS.PublicationMatchedStatus;
import DDS.Publisher;
import DDS.PublisherListener;
import DDS.PublisherQos;
import DDS.PublisherQosHolder;
import DDS.TOPIC_QOS_DEFAULT;
import DDS.Topic;
import DDS.TopicQos;
import DDS.TopicQosHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensplice.dds.dcps.DataWriterImpl;
import org.opensplice.dds.dcps.DomainParticipantImpl;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.ListenerDispatcher;
import org.opensplice.dds.dcps.PublisherBase;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.TopicImpl;
import org.opensplice.dds.dcps.Utilities;

public class PublisherImpl
extends PublisherBase
implements Publisher {
    private static final long serialVersionUID = 518234841867708066L;
    private String name;
    private DomainParticipantImpl participant = null;
    private DataWriterQos defaultDataWriterQos = Utilities.defaultDataWriterQos;
    private final Set<DataWriterImpl> writers = Collections.synchronizedSet(new HashSet());
    private PublisherListener listener = null;
    private boolean factoryAutoEnable = false;

    protected PublisherImpl() {
    }

    protected int init(DomainParticipantImpl participant, String name, PublisherQos qos) {
        int result = 0;
        assert (participant != null);
        assert (qos != null);
        long uParticipant = participant.get_user_object();
        if (uParticipant != 0L) {
            long uPublisher = this.jniPublisherNew(uParticipant, name, qos);
            if (uPublisher != 0L) {
                this.set_user_object(uPublisher);
                this.name = name;
                this.factoryAutoEnable = qos.entity_factory.autoenable_created_entities;
                this.participant = participant;
                this.setDomainId(participant.getDomainId());
            }
        } else {
            result = 9;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        PublisherImpl publisherImpl = this;
        synchronized (publisherImpl) {
            long uPublisher = this.get_user_object();
            if (uPublisher != 0L) {
                if (this.writers.size() == 0) {
                    if (this.listener != null) {
                        result = this.set_listener(this.listener, 0);
                    }
                    if (result == 0 && (result = this.disable_callbacks()) == 0 && (result = this.detach_statuscondition()) == 0) {
                        this.participant = null;
                        this.name = null;
                        result = this.jniPublisherFree(uPublisher);
                        if (result == 0) {
                            result = super.deinit();
                        }
                    }
                } else {
                    result = 4;
                    ReportStack.report(result, "Publisher still contains '" + this.writers.size() + "' DataWriter entities.");
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataWriter create_datawriter(Topic a_topic, DataWriterQos qos, DataWriterListener a_listener, int mask) {
        DataWriterImpl writer = null;
        int result = 0;
        ReportStack.start();
        if (a_topic == null) {
            result = 3;
            ReportStack.report(result, "a_topic 'null' is invalid.");
        } else if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAWRITER_QOS_DEFAULT.value) {
            qos = this.defaultDataWriterQos;
        } else if (qos == DATAWRITER_QOS_USE_TOPIC_QOS.value) {
            TopicQosHolder topicQosHolder = new TopicQosHolder();
            a_topic.get_qos(topicQosHolder);
            DataWriterQosHolder writerQosHolder = new DataWriterQosHolder();
            result = this.copy_from_topic_qos(writerQosHolder, topicQosHolder.value);
            if (result == 0) {
                qos = writerQosHolder.value;
                result = Utilities.checkQos(qos);
            }
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            PublisherImpl publisherImpl = this;
            synchronized (publisherImpl) {
                long uPublisher = this.get_user_object();
                if (uPublisher != 0L) {
                    TopicImpl topic = (TopicImpl)a_topic;
                    if (this.participant.equals(topic.get_participant())) {
                        String name = "writer <" + topic.get_name() + ">";
                        writer = (DataWriterImpl)topic.create_datawriter();
                        if (writer != null) {
                            result = writer.init(this, name, topic, qos);
                            if (result == 0) {
                                this.writers.add(writer);
                                ListenerDispatcher dispatcher = this.get_dispatcher();
                                result = writer.set_dispatcher(dispatcher);
                            } else {
                                writer = null;
                            }
                            if (result == 0) {
                                result = writer.set_listener(a_listener, mask);
                            }
                            if (result == 0 && this.factoryAutoEnable) {
                                result = writer.enable();
                            }
                            if (result != 0 && writer != null) {
                                this.delete_datawriter(writer);
                                writer = null;
                            }
                        }
                    } else {
                        result = 4;
                        ReportStack.report(result, "Topic does belong to the same DomainParticipant as this Publisher.");
                    }
                } else {
                    result = 9;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_datawriter(DataWriter writer) {
        int result = 0;
        ReportStack.start();
        if (writer == null) {
            result = 3;
            ReportStack.report(result, "DataWriter 'null' is invalid.");
        } else {
            DataWriterImpl dw = (DataWriterImpl)writer;
            boolean removed = false;
            PublisherImpl publisherImpl = this;
            synchronized (publisherImpl) {
                removed = this.writers.remove(dw);
                if (removed) {
                    result = dw.deinit();
                    if (result == 4) {
                        this.writers.add(dw);
                    }
                } else if (dw.get_user_object() == 0L) {
                    result = 9;
                } else {
                    result = 4;
                    ReportStack.report(result, "DataWriter not created by Publisher");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataWriter lookup_datawriter(String topic_name) {
        DataWriterImpl found = null;
        ReportStack.start();
        Set<DataWriterImpl> set = this.writers;
        synchronized (set) {
            Iterator<DataWriterImpl> i = this.writers.iterator();
            while (found == null && i.hasNext()) {
                found = i.next();
                if (found.get_topic().get_name().equals(topic_name)) continue;
                found = null;
            }
        }
        ReportStack.flush(this, false);
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains_entity(long a_handle) {
        boolean found = false;
        ReportStack.start();
        Set<DataWriterImpl> set = this.writers;
        synchronized (set) {
            Iterator<DataWriterImpl> it = this.writers.iterator();
            while (it.hasNext() && !found) {
                long handle = it.next().get_instance_handle();
                found = handle == a_handle;
            }
        }
        ReportStack.flush(this, false);
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_contained_entities() {
        int endResult = 0;
        ReportStack.start();
        HashSet<DataWriterImpl> survivors = new HashSet<DataWriterImpl>();
        DataWriterImpl dw = null;
        do {
            dw = null;
            Set<DataWriterImpl> set = this.writers;
            synchronized (set) {
                Iterator<DataWriterImpl> dwi = this.writers.iterator();
                while (dwi.hasNext()) {
                    dw = dwi.next();
                    dwi.remove();
                    if (survivors.contains(dw)) continue;
                }
            }
            if (dw == null) continue;
            int result = dw.deinit();
            if (result != 0 && result != 9) {
                survivors.add(dw);
                set = this.writers;
                synchronized (set) {
                    this.writers.add(dw);
                }
            }
            if (result == 0) continue;
            ReportStack.report(result, "Deletion of DataWriter contained in Publisher failed.");
            if (endResult != 0) continue;
            endResult = result;
        } while (dw != null);
        ReportStack.flush(this, endResult != 0);
        return endResult;
    }

    @Override
    public int set_qos(PublisherQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == PUBLISHER_QOS_DEFAULT.value) {
            PublisherQosHolder holder = new PublisherQosHolder();
            this.participant.get_default_publisher_qos(holder);
            qos = holder.value;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            long uPublisher = this.get_user_object();
            if (uPublisher != 0L) {
                result = this.jniSetQos(uPublisher, qos);
                if (result == 0) {
                    this.factoryAutoEnable = qos.entity_factory.autoenable_created_entities;
                }
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_qos(PublisherQosHolder qosHolder) {
        int result = 0;
        ReportStack.start();
        if (qosHolder == null) {
            result = 0;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            long uPublisher = this.get_user_object();
            result = uPublisher != 0L ? this.jniGetQos(uPublisher, qosHolder) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int set_listener(PublisherListener a_listener, int mask) {
        long uPublisher = 0L;
        int result = 0;
        ReportStack.start();
        PublisherImpl publisherImpl = this;
        synchronized (publisherImpl) {
            uPublisher = this.get_user_object();
            if (uPublisher != 0L) {
                this.listener = a_listener;
                result = this.set_listener_interest(mask);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public PublisherListener get_listener() {
        return this.listener;
    }

    @Override
    public int suspend_publications() {
        long uPublisher = 0L;
        int result = 0;
        ReportStack.start();
        uPublisher = this.get_user_object();
        result = uPublisher != 0L ? this.jniSuspendPublications(uPublisher) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int resume_publications() {
        long uPublisher = 0L;
        int result = 0;
        ReportStack.start();
        uPublisher = this.get_user_object();
        result = uPublisher != 0L ? this.jniResumePublications(uPublisher) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int begin_coherent_changes() {
        long uPublisher = 0L;
        int result = 0;
        ReportStack.start();
        uPublisher = this.get_user_object();
        result = uPublisher != 0L ? this.jniBeginCoherentChanges(uPublisher) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int end_coherent_changes() {
        long uPublisher = 0L;
        int result = 0;
        ReportStack.start();
        uPublisher = this.get_user_object();
        result = uPublisher != 0L ? this.jniEndCoherentChanges(uPublisher) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int wait_for_acknowledgments(Duration_t max_wait) {
        long uPublisher = 0L;
        int result = 0;
        ReportStack.start();
        result = Utilities.checkDuration(max_wait);
        result = result == 0 ? ((uPublisher = this.get_user_object()) != 0L ? this.jniWaitForAcknowledgments(uPublisher, max_wait) : 9) : 3;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public DomainParticipant get_participant() {
        DomainParticipantImpl participant = null;
        ReportStack.start();
        if (this.get_user_object() != 0L) {
            participant = this.participant;
        }
        ReportStack.flush(this, participant == null);
        return participant;
    }

    @Override
    public int set_default_datawriter_qos(DataWriterQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAWRITER_QOS_USE_TOPIC_QOS.value) {
            result = 3;
            ReportStack.report(result, "QoS 'DATAWRITER_QOS_USE_TOPIC_QOS' is invalid in this context.");
        } else if (qos == DATAWRITER_QOS_DEFAULT.value) {
            qos = Utilities.defaultDataWriterQos;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            if (this.get_user_object() != 0L) {
                this.defaultDataWriterQos = Utilities.deepCopy(qos);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_default_datawriter_qos(DataWriterQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (this.get_user_object() == 0L) {
            result = 9;
        } else {
            qos.value = Utilities.deepCopy(this.defaultDataWriterQos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int copy_from_topic_qos(DataWriterQosHolder qosHolder, TopicQos topic_qos) {
        int result = 0;
        ReportStack.start();
        if (qosHolder == null) {
            result = 3;
            ReportStack.report(result, "a_datawriter_qos 'null' is invalid.");
        } else if (topic_qos == null) {
            result = 3;
            ReportStack.report(result, "a_topic_qos 'null' is invalid.");
        } else if (topic_qos == TOPIC_QOS_DEFAULT.value) {
            TopicQosHolder holder = new TopicQosHolder();
            this.participant.get_default_topic_qos(holder);
            topic_qos = holder.value;
        } else {
            result = Utilities.checkQos(topic_qos);
        }
        if (result == 0) {
            DataWriterQos qos = qosHolder.value;
            if (qos == null) {
                qos = Utilities.deepCopy(this.defaultDataWriterQos);
            }
            qos.durability = Utilities.deepCopy(topic_qos.durability);
            qos.deadline = Utilities.deepCopy(topic_qos.deadline);
            qos.latency_budget = Utilities.deepCopy(topic_qos.latency_budget);
            qos.liveliness = Utilities.deepCopy(topic_qos.liveliness);
            qos.reliability = Utilities.deepCopy(topic_qos.reliability);
            qos.destination_order = Utilities.deepCopy(topic_qos.destination_order);
            qos.history = Utilities.deepCopy(topic_qos.history);
            qos.resource_limits = Utilities.deepCopy(topic_qos.resource_limits);
            qos.transport_priority = Utilities.deepCopy(topic_qos.transport_priority);
            qos.lifespan = Utilities.deepCopy(topic_qos.lifespan);
            qos.ownership = Utilities.deepCopy(topic_qos.ownership);
            qosHolder.value = qos;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    protected int notify(Event e) {
        int result = 0;
        PublisherListener pl = this.listener;
        if (pl == null) {
            return result;
        }
        switch (e.kind) {
            case 2: {
                pl.on_offered_deadline_missed((DataWriter)((Object)e.observable), (OfferedDeadlineMissedStatus)e.status);
                break;
            }
            case 32: {
                pl.on_offered_incompatible_qos((DataWriter)((Object)e.observable), (OfferedIncompatibleQosStatus)e.status);
                break;
            }
            case 2048: {
                pl.on_liveliness_lost((DataWriter)((Object)e.observable), (LivelinessLostStatus)e.status);
                break;
            }
            case 8192: {
                pl.on_publication_matched((DataWriter)((Object)e.observable), (PublicationMatchedStatus)e.status);
                break;
            }
            default: {
                ReportStack.report(2, "Received unsupported event kind '" + e.kind + "'.");
            }
        }
        return result;
    }

    private native long jniPublisherNew(long var1, String var3, PublisherQos var4);

    private native int jniPublisherFree(long var1);

    private native int jniSetQos(long var1, PublisherQos var3);

    private native int jniGetQos(long var1, PublisherQosHolder var3);

    private native int jniSuspendPublications(long var1);

    private native int jniResumePublications(long var1);

    private native int jniBeginCoherentChanges(long var1);

    private native int jniEndCoherentChanges(long var1);

    private native int jniWaitForAcknowledgments(long var1, Duration_t var3);
}

