/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DATAWRITER_QOS_DEFAULT;
import DDS.DATAWRITER_QOS_USE_TOPIC_QOS;
import DDS.DataWriter;
import DDS.DataWriterListener;
import DDS.DataWriterQos;
import DDS.DataWriterQosHolder;
import DDS.Duration_t;
import DDS.InstanceHandleSeqHolder;
import DDS.LivelinessLostStatus;
import DDS.LivelinessLostStatusHolder;
import DDS.OfferedDeadlineMissedStatus;
import DDS.OfferedDeadlineMissedStatusHolder;
import DDS.OfferedIncompatibleQosStatus;
import DDS.OfferedIncompatibleQosStatusHolder;
import DDS.PublicationMatchedStatus;
import DDS.PublicationMatchedStatusHolder;
import DDS.Publisher;
import DDS.SubscriptionBuiltinTopicDataHolder;
import DDS.TOPIC_QOS_DEFAULT;
import DDS.Topic;
import org.opensplice.dds.dcps.DataWriterBase;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.PublisherImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.TopicImpl;
import org.opensplice.dds.dcps.Utilities;

public class DataWriterImpl
extends DataWriterBase
implements DataWriter {
    private static final long serialVersionUID = 278508615771428238L;
    private String name;
    private PublisherImpl publisher;
    private TopicImpl topic;
    private DataWriterListener listener = null;

    protected DataWriterImpl() {
    }

    protected int init(PublisherImpl publisher, String name, TopicImpl topic, DataWriterQos qos) {
        int result = 0;
        long uPublisher = publisher.get_user_object();
        long uTopic = topic.get_user_object();
        if (uPublisher != 0L && uTopic != 0L) {
            long uWriter = this.jniDataWriterNew(uPublisher, name, uTopic, qos);
            if (uWriter != 0L) {
                topic.keep();
                this.set_user_object(uWriter);
                this.setDomainId(publisher.getDomainId());
                this.publisher = publisher;
                this.name = name;
                this.topic = topic;
            } else {
                result = 3;
            }
        } else {
            result = 9;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        DataWriterImpl dataWriterImpl = this;
        synchronized (dataWriterImpl) {
            long uWriter = this.get_user_object();
            if (uWriter != 0L) {
                if (this.listener != null) {
                    result = this.set_listener(this.listener, 0);
                }
                if (result == 0 && (result = this.disable_callbacks()) == 0 && (result = this.detach_statuscondition()) == 0) {
                    this.topic.free();
                    this.name = null;
                    this.topic = null;
                    this.publisher = null;
                    result = this.jniDataWriterFree(uWriter);
                    if (result == 0) {
                        result = super.deinit();
                    }
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    @Override
    public int set_qos(DataWriterQos qos) {
        DataWriterQosHolder holder;
        int result = 3;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAWRITER_QOS_DEFAULT.value) {
            holder = new DataWriterQosHolder();
            result = this.publisher.get_default_datawriter_qos(holder);
            qos = holder.value;
        } else if (qos == DATAWRITER_QOS_USE_TOPIC_QOS.value) {
            holder = new DataWriterQosHolder();
            result = this.publisher.copy_from_topic_qos(holder, TOPIC_QOS_DEFAULT.value);
            if (result == 0) {
                qos = holder.value;
                result = Utilities.checkQos(qos);
            }
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            long uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniSetQos(uWriter, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_qos(DataWriterQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            long uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniGetQos(uWriter, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int set_listener(DataWriterListener a_listener, int mask) {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        DataWriterImpl dataWriterImpl = this;
        synchronized (dataWriterImpl) {
            uWriter = this.get_user_object();
            if (uWriter != 0L) {
                this.listener = a_listener;
                result = this.set_listener_interest(mask);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public DataWriterListener get_listener() {
        return this.listener;
    }

    @Override
    public Topic get_topic() {
        return this.topic;
    }

    @Override
    public Publisher get_publisher() {
        return this.publisher;
    }

    @Override
    public int wait_for_acknowledgments(Duration_t max_wait) {
        long uWriter = 0L;
        int result = 9;
        ReportStack.start();
        uWriter = this.get_user_object();
        if (uWriter != 0L) {
            result = Utilities.checkDuration(max_wait);
            if (result == 0) {
                result = this.jniWaitForAcknowledgments(uWriter, max_wait);
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int get_liveliness_lost_status(LivelinessLostStatusHolder status) {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniGetLivelinessLostStatus(uWriter, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_offered_deadline_missed_status(OfferedDeadlineMissedStatusHolder status) {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniGetOfferedDeadlineMissedStatus(uWriter, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_offered_incompatible_qos_status(OfferedIncompatibleQosStatusHolder status) {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniGetOfferedIncompatibleQosStatus(uWriter, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_publication_matched_status(PublicationMatchedStatusHolder status) {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniGetPublicationMatchedStatus(uWriter, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int assert_liveliness() {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        uWriter = this.get_user_object();
        result = uWriter != 0L ? this.jniAssertLiveliness(uWriter) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_matched_subscriptions(InstanceHandleSeqHolder subscription_handles) {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        if (subscription_handles == null) {
            result = 3;
            ReportStack.report(result, "subscription_handles 'null' is invalid.");
        } else {
            uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniGetMatchedSubscriptions(uWriter, subscription_handles) : 9;
        }
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    public int get_matched_subscription_data(SubscriptionBuiltinTopicDataHolder subscription_data, long subscription_handle) {
        long uWriter = 0L;
        int result = 0;
        ReportStack.start();
        if (subscription_data == null) {
            result = 3;
            ReportStack.report(result, "subscription_data 'null' is invalid.");
        } else if (subscription_handle == 0L) {
            result = 3;
            ReportStack.report(result, "subscription_handle 'HANDLE_NIL' is invalid.");
        } else {
            uWriter = this.get_user_object();
            result = uWriter != 0L ? this.jniGetMatchedSubscriptionData(uWriter, subscription_data, subscription_handle) : 9;
        }
        ReportStack.flush(this, result != 0 && result != 11);
        return result;
    }

    @Override
    protected int notify(Event e) {
        int result = 0;
        DataWriterListener dwl = this.listener;
        if (dwl == null) {
            return result;
        }
        switch (e.kind) {
            case 2: {
                dwl.on_offered_deadline_missed(this, (OfferedDeadlineMissedStatus)e.status);
                break;
            }
            case 32: {
                dwl.on_offered_incompatible_qos(this, (OfferedIncompatibleQosStatus)e.status);
                break;
            }
            case 2048: {
                dwl.on_liveliness_lost(this, (LivelinessLostStatus)e.status);
                break;
            }
            case 8192: {
                dwl.on_publication_matched(this, (PublicationMatchedStatus)e.status);
                break;
            }
            default: {
                ReportStack.report(2, "Received unsupported event kind '" + e.kind + "'");
            }
        }
        return result;
    }

    private native long jniDataWriterNew(long var1, String var3, long var4, DataWriterQos var6);

    private native int jniDataWriterFree(long var1);

    private native int jniSetQos(long var1, DataWriterQos var3);

    private native int jniGetQos(long var1, DataWriterQosHolder var3);

    private native int jniWaitForAcknowledgments(long var1, Duration_t var3);

    private native int jniGetLivelinessLostStatus(long var1, LivelinessLostStatusHolder var3);

    private native int jniGetOfferedDeadlineMissedStatus(long var1, OfferedDeadlineMissedStatusHolder var3);

    private native int jniGetOfferedIncompatibleQosStatus(long var1, OfferedIncompatibleQosStatusHolder var3);

    private native int jniGetPublicationMatchedStatus(long var1, PublicationMatchedStatusHolder var3);

    private native int jniAssertLiveliness(long var1);

    private native int jniGetMatchedSubscriptions(long var1, InstanceHandleSeqHolder var3);

    private native int jniGetMatchedSubscriptionData(long var1, SubscriptionBuiltinTopicDataHolder var3, long var4);
}

