/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Store;

public class Folder
implements Comparable<Folder> {
    private final Store store;
    private final String name;

    Folder(Store store, String name) {
        this.store = store;
        this.name = name;
    }

    public List<Image> listImages() throws DAQException {
        ArrayList<Image> result = new ArrayList<Image>();
        ArrayList<ImageMetaData> metaData = new ArrayList<ImageMetaData>();
        this.store.listImages(this.name, metaData);
        metaData.forEach(meta -> result.add(new Image(this.store, (ImageMetaData)meta)));
        return result;
    }

    public Image find(String name) throws DAQException {
        try {
            ImageMetaData meta = this.store.findImage(name, this.name);
            return new Image(this.store, meta);
        }
        catch (DAQException x) {
            if (x.rc() == 33) {
                return null;
            }
            throw x;
        }
    }

    public Image insert(ImageMetaData meta) throws DAQException {
        ImageMetaData metaNew = this.store.addImageToFolder(meta.getName(), this.name, meta);
        return new Image(this.store, metaNew);
    }

    @Override
    public int compareTo(Folder o) {
        return this.name.compareTo(o.name);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.name, ((Folder)obj).name);
    }

    Store getStore() {
        return this.store;
    }
}

