/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mapping {
    private final List<PatternPlus> patterns;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Mapping defaultMapping() {
        try (InputStream in = Mapping.class.getResourceAsStream("pattern.map");){
            Mapping mapping = new Mapping(in);
            return mapping;
        }
        catch (IOException x) {
            throw new RuntimeException("Failed to load default pattern.map", x);
        }
    }

    public Mapping(InputStream in) throws IOException {
        block15: {
            this.patterns = new ArrayList<PatternPlus>();
            Pattern legacyPattern = Pattern.compile("(\\w+)\\s*:\\s(.*)");
            Pattern flexiblePattern = Pattern.compile("(\\w+)\\s*:\\s*\\|\\s*(.+)\\s*\\|\\s*(.+)\\s*\\|\\s*(.+)\\s*\\|");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while (true) {
                    Pattern pattern;
                    String value;
                    String key;
                    if ((line = reader.readLine()) == null) {
                        break block15;
                    }
                    if (line.startsWith("#")) continue;
                    Matcher flexibleMatcher = flexiblePattern.matcher(line);
                    Matcher legacyMatcher = legacyPattern.matcher(line);
                    if (flexibleMatcher.matches()) {
                        key = flexibleMatcher.group(1);
                        value = flexibleMatcher.group(2);
                        pattern = Pattern.compile(value, 2);
                        this.patterns.add(new PatternPlus(pattern, key, flexibleMatcher.group(3), flexibleMatcher.group(4)));
                        continue;
                    }
                    if (!legacyMatcher.matches()) break;
                    key = legacyMatcher.group(1);
                    value = legacyMatcher.group(2);
                    pattern = Pattern.compile(value, 2);
                    this.patterns.add(new PatternPlus(pattern, key));
                }
                throw new IOException("Invalid mapping file line: " + line);
            }
        }
    }

    public List<PatternPlus> getPatternList() {
        return Collections.unmodifiableList(this.patterns);
    }

    public Match match(String path) {
        for (PatternPlus patternPlus : this.patterns) {
            Matcher matcher = patternPlus.getPattern().matcher(path);
            if (!matcher.matches()) continue;
            return new Match(matcher, patternPlus);
        }
        return null;
    }

    public Map<Pattern, String> getPatterns() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class Match {
        private final Matcher matcher;
        private final PatternPlus patternPlus;

        private Match(Matcher matcher, PatternPlus patternPlus) {
            this.patternPlus = patternPlus;
            this.matcher = matcher;
        }

        public String getPatternName() {
            return this.patternPlus.getPatternName();
        }

        public String getLocation() {
            if (this.patternPlus.getLocation() == null) {
                StringBuilder builder = new StringBuilder();
                int groupCount = this.matcher.groupCount();
                for (int g = 1; g < groupCount; ++g) {
                    builder.append(this.matcher.group(g));
                }
                return builder.toString();
            }
            return this.matcher.replaceAll(this.patternPlus.getLocation());
        }

        public String getPathAfterMatch() {
            if (this.patternPlus.getAfter() == null) {
                int groupCount = this.matcher.groupCount();
                return this.matcher.group(groupCount);
            }
            return this.matcher.replaceAll(this.patternPlus.getAfter());
        }
    }

    public static class PatternPlus {
        private final Pattern pattern;
        private final String patternName;
        private final String location;
        private final String after;

        PatternPlus(Pattern pattern, String patternName) {
            this.pattern = pattern;
            this.patternName = patternName;
            this.location = null;
            this.after = null;
        }

        private PatternPlus(Pattern pattern, String patternName, String location, String after) {
            this.pattern = pattern;
            this.patternName = patternName;
            this.location = location;
            this.after = after;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getPatternName() {
            return this.patternName;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAfter() {
            return this.after;
        }
    }
}

