/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class DelimitedStringSplitJoin {
    private static final char DEFAULT_DELIMITER = ':';
    private static final char DEFAULT_ESCAPE = '\\';
    private final String escapedDelimiter;
    private final String escapedEscape;
    private final Pattern splitPattern;
    private final Pattern unescapePattern;
    private final char delimiter;

    public DelimitedStringSplitJoin() {
        this(':', '\\');
    }

    public DelimitedStringSplitJoin(char delimiter, char escape) {
        this.delimiter = delimiter;
        this.escapedDelimiter = Matcher.quoteReplacement(String.valueOf(delimiter));
        this.escapedEscape = Matcher.quoteReplacement(String.valueOf(escape));
        this.splitPattern = Pattern.compile(String.format("(?<!%s)%s", this.escapedEscape, this.escapedDelimiter));
        this.unescapePattern = Pattern.compile(String.format("%s(.)", this.escapedEscape));
    }

    public String[] split(CharSequence input) {
        return (String[])this.splitPattern.splitAsStream(input).map(s -> this.unescape((String)s)).toArray(String[]::new);
    }

    public String join(CharSequence[] input) {
        return Arrays.stream(input).collect(this.joining());
    }

    public String join(Iterable<? extends CharSequence> input) {
        return StreamSupport.stream(input.spliterator(), true).collect(this.joining());
    }

    public Collector<CharSequence, ?, String> joining() {
        return Collector.of(() -> new StringJoiner(String.valueOf(this.delimiter)), (joiner, item) -> joiner.add(this.escape((CharSequence)item)), StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0]);
    }

    private String escape(CharSequence s) {
        return s.toString().replaceAll(this.escapedEscape, this.escapedEscape + this.escapedEscape).replaceAll(this.escapedDelimiter, this.escapedEscape + this.escapedDelimiter);
    }

    private String unescape(String s) {
        return this.unescapePattern.matcher(s).replaceAll("$1");
    }

    public Map<String, String> zip(CharSequence keys, CharSequence values) {
        String[] v;
        String[] k = this.split(keys);
        if (k.length != (v = this.split(values)).length) {
            throw new IllegalArgumentException("Inconsistent keys, values " + keys + " " + values);
        }
        return IntStream.range(0, k.length).boxed().collect(Collectors.toMap(i -> k[i], i -> v[i]));
    }
}

