/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class ShutterSimulation
implements ShutterInterface {
    private final CCS ccs;
    private final State shutterState;

    ShutterSimulation(CCS ccs, State shutterState) {
        this.ccs = ccs;
        this.shutterState = shutterState;
    }

    @Override
    public void start(String configName) throws ExecutionException {
    }

    @Override
    public void expose(Duration exposureTime) throws ExecutionException {
        this.shutterState.checkState(new Enum[]{Shutter.ShutterState.CLOSED});
        this.shutterState.setState(Shutter.ShutterState.OPENING);
        Duration time = Shutter.MOVE_TIME;
        this.ccs.schedule(time, () -> this.shutterState.setState(Shutter.ShutterState.OPEN));
        time = time.plus(exposureTime);
        this.ccs.schedule(time, () -> this.shutterState.setState(Shutter.ShutterState.CLOSING));
        time = time.plus(Shutter.MOVE_TIME);
        this.ccs.schedule(time, () -> this.shutterState.setState(Shutter.ShutterState.CLOSED));
    }

    @Override
    public void open() throws ExecutionException {
        this.shutterState.setState(Shutter.ShutterState.OPENING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(Shutter.ShutterState.OPEN));
    }

    @Override
    public void close() throws ExecutionException {
        this.shutterState.setState(Shutter.ShutterState.CLOSING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(Shutter.ShutterState.CLOSED));
    }
}

