/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMCommandSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

class ControlledSubsystem {
    private static final Logger LOG = Logger.getLogger(ControlledSubsystem.class.getName());
    protected final MCMConfig config;
    protected final MCMCommandSender commandSender;
    protected final CCS ccs;

    public ControlledSubsystem(Subsystem mcm, final String targetSubsystem, CCS ccs, MCMConfig config) {
        this.config = config;
        this.commandSender = new MCMCommandSender(targetSubsystem, mcm.getMessagingAccess(), (AgentLockService)mcm.getAgentService(AgentLockService.class));
        this.ccs = ccs;
        mcm.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (AgentInfo agent : agents) {
                    if (!agent.getName().equals(targetSubsystem)) continue;
                    try {
                        StateBundle initialState = ControlledSubsystem.this.commandSender.sendCommand(StateBundle.class, "getState", new Object[0]);
                        ControlledSubsystem.this.onConnect(agent, initialState);
                    }
                    catch (ExecutionException x) {
                        LOG.log(Level.SEVERE, "Failed to get initial state from subsystem " + targetSubsystem, x);
                    }
                }
            }

            public void disconnected(AgentInfo ... agents) {
                for (AgentInfo agent : agents) {
                    if (!agent.getName().equals(targetSubsystem)) continue;
                    ControlledSubsystem.this.onDisconnect(agent);
                }
            }
        });
        Predicate targetSubsystemFilter = BusMessageFilterFactory.messageOrigin((String)targetSubsystem);
        mcm.getMessagingAccess().addStatusMessageListener(msg -> {
            if (msg instanceof StatusStateChangeNotification) {
                this.onStateChange((StatusStateChangeNotification)msg);
            } else if (!(msg instanceof StatusHeartBeat)) {
                this.onEvent(msg);
            }
        }, targetSubsystemFilter);
    }

    public void start(String configName) throws ExecutionException {
        try {
            this.commandSender.lock(10);
            this.commandSender.sendCommand("publishConfigurationInfo", new Object[0]);
        }
        catch (IOException | UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new ExecutionException("Failed to lock subsystem " + this.config.getShutterSubsystemName(), x);
        }
    }

    protected void onConnect(AgentInfo agent, StateBundle initialState) {
    }

    protected void onDisconnect(AgentInfo agent) {
    }

    protected void onStateChange(StatusStateChangeNotification statusChange) {
    }

    protected void onEvent(StatusMessage msg) {
    }
}

