/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class MCMCCSLayer
implements MCMLayer {
    private final Subsystem subsystem;
    private final CCS ccs;
    private final OCSBridgeConfig config;

    MCMCCSLayer(Subsystem subsystem, CCS ccs, OCSBridgeConfig config) {
        this.subsystem = subsystem;
        this.ccs = ccs;
        this.config = config;
        Predicate stateChangeFilter = BusMessageFilterFactory.messageOrigin((String)config.getMCMName()).and(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class));
        subsystem.getMessagingAccess().addStatusMessageListener(msg -> this.handleMCMStatusChangeMessage(msg), stateChangeFilter);
        Predicate eventFilter = BusMessageFilterFactory.messageOrigin((String)config.getMCMName()).and(BusMessageFilterFactory.embeddedObjectClass(KeyValueData.class));
        subsystem.getMessagingAccess().addStatusMessageListener(msg -> this.handleMCMEvent(msg), eventFilter);
        for (String l : config.getListenSubsystems()) {
            Predicate subsystemFilter = BusMessageFilterFactory.messageOrigin((String)l);
            subsystem.getMessagingAccess().addStatusMessageListener(msg -> this.handleSubsystemEvent(msg), subsystemFilter);
        }
    }

    @Override
    public CCSCommand.CCSCommandResponse execute(CCSCommand ccsCommand) {
        CCSBusesExecutor executor = new CCSBusesExecutor(ccsCommand);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    @Override
    public void addStateChangeListener(State.StateChangeListener<Enum> stateChangeListener) {
        this.ccs.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void removeStateChangeListener(State.StateChangeListener<Enum> stateChangeListener) {
        this.ccs.removeStateChangeListener(stateChangeListener);
    }

    @Override
    public void addEventListener(CCSEvent.CCSEventListener eventListener) {
        this.ccs.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(CCSEvent.CCSEventListener eventListener) {
        this.ccs.removeEventListener(eventListener);
    }

    @Override
    public void addStatusMessageListener(EventListener<StatusMessage> eventListener) {
        this.ccs.addStatusMessageListener(eventListener);
    }

    @Override
    public void removeStatusMessageListener(EventListener<StatusMessage> eventListener) {
        this.ccs.removeStatusMessageListener(eventListener);
    }

    private void handleMCMStatusChangeMessage(StatusMessage msg) {
        StatusStateChangeNotification statusChange = (StatusStateChangeNotification)msg;
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        CCSTimeStamp when = statusChange.getCCSTimeStamp();
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.ccs.getAggregateStatus().add(when, new State<Enum>((Enum)value)));
    }

    private void handleMCMEvent(StatusMessage msg) {
        KeyValueData data;
        Serializable object = msg.getObject();
        if (object instanceof KeyValueData && "CCSEvent".equals((data = (KeyValueData)object).getKey())) {
            CCSEvent evt = (CCSEvent)data.getValue();
            this.ccs.fireEvent(evt);
            return;
        }
        this.ccs.fireEvent(msg);
    }

    private void handleSubsystemEvent(StatusMessage msg) {
        this.ccs.fireEvent(msg);
    }

    private class CCSBusesExecutor
    extends CCSExecutor {
        private final ArrayBlockingQueue queue = new ArrayBlockingQueue(2);
        private final CCSCommand ccsCommand;

        public CCSBusesExecutor(CCSCommand ccsCommand) {
            this.ccsCommand = ccsCommand;
            CommandOriginator originator = new CommandOriginator(){

                public void processAck(CommandAck ack) {
                    CCSBusesExecutor.this.queue.offer(ack);
                }

                public void processResult(CommandResult result) {
                    CCSBusesExecutor.this.queue.offer(result);
                }

                public void processNack(CommandNack nack) {
                    CCSBusesExecutor.this.queue.offer(nack);
                }
            };
            CommandRequest request = new CommandRequest(MCMCCSLayer.this.config.getMCMName(), (BasicCommand)new RawCommand(ccsCommand.getCommand(), ccsCommand.getArguments()));
            MCMCCSLayer.this.subsystem.getMessagingAccess().sendCommandRequest(request, originator);
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            try {
                Object result = this.queue.take();
                if (result instanceof CommandAck) {
                    return ((CommandAck)result).getTimeout();
                }
                if (result instanceof CommandNack) {
                    throw new CCSCommand.CCSPreconditionsNotMet(((CommandNack)result).getReason());
                }
                throw new RuntimeException("Unexpected object received while waiting for ack/nack: " + this.ccsCommand.toString());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting for command ack/nack: " + this.ccsCommand.toString(), ex);
            }
        }

        @Override
        protected void execute() throws ExecutionException {
            block5: {
                try {
                    Object result = this.queue.take();
                    if (result instanceof CommandResult) {
                        CommandResult cr = (CommandResult)result;
                        if (!cr.wasSuccessful()) {
                            Throwable t = (Throwable)cr.getObject();
                            if (t instanceof ExecutionException) {
                                throw (ExecutionException)t;
                            }
                            throw new ExecutionException("MCM command failed: " + this.ccsCommand.toString(), t);
                        }
                        break block5;
                    }
                    throw new RuntimeException("Unexpected object received while waiting for command result: " + this.ccsCommand + " " + result);
                }
                catch (InterruptedException x) {
                    throw new RuntimeException("Interrupt while waiting for command result: " + this.ccsCommand.toString(), x);
                }
            }
        }
    }
}

