/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.util.Contract;

public final class StringValues {
    public static final StringValue EMPTY = new StringValue(){

        @Override
        public String getString(Object value) {
            return "";
        }
    };
    public static final StringValue TO_STRING = new StringValue(){

        @Override
        public String getString(Object value) {
            return value != null ? value.toString() : EMPTY.getString(value);
        }
    };
    public static final StringValue FILE_NAME = new StringValue(){

        @Override
        public String getString(Object value) {
            if (value instanceof File) {
                FileSystemView fsv = FileSystemView.getFileSystemView();
                return fsv.getSystemDisplayName((File)value);
            }
            return TO_STRING.getString(value);
        }
    };
    public static final StringValue FILE_TYPE = new StringValue(){

        @Override
        public String getString(Object value) {
            if (value instanceof File) {
                FileSystemView fsv = FileSystemView.getFileSystemView();
                return fsv.getSystemTypeDescription((File)value);
            }
            return TO_STRING.getString(value);
        }
    };
    private static Locale defaultLocale;
    public static final FormatStringValue DATE_TO_STRING;
    public static final FormatStringValue NUMBER_TO_STRING;
    public static final StringValue TO_STRING_UI;
    public static final StringValue EMPTY_UI;

    private static boolean localeChanged() {
        boolean changed;
        boolean bl = changed = !Locale.getDefault().equals(defaultLocale);
        if (changed) {
            defaultLocale = Locale.getDefault();
        }
        return changed;
    }

    private StringValues() {
    }

    static {
        DATE_TO_STRING = new FormatStringValue(){

            @Override
            public String getString(Object value) {
                if (this.format == null || StringValues.localeChanged()) {
                    this.format = DateFormat.getDateInstance();
                }
                return super.getString(value);
            }
        };
        NUMBER_TO_STRING = new FormatStringValue(){

            @Override
            public String getString(Object value) {
                if (this.format == null || StringValues.localeChanged()) {
                    this.format = NumberFormat.getNumberInstance();
                }
                return super.getString(value);
            }
        };
        TO_STRING_UI = new StringValueUIResource(TO_STRING);
        EMPTY_UI = new StringValueUIResource(EMPTY);
    }

    public static class StringValueUIResource
    implements StringValue,
    UIResource {
        private StringValue delegate;

        public StringValueUIResource(StringValue toString) {
            Contract.asNotNull((Object)toString, (String)"delegate StringValue must not be null");
            this.delegate = toString;
        }

        @Override
        public String getString(Object value) {
            return this.delegate.getString(value);
        }
    }
}

