/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.util.LinkedHashSet;
import java.util.Set;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.imagehandling.states.ImageHandlingState;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.location.Location;

class RebNode
implements HasLifecycle {
    private Reb reb;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private FitsService fitsService;
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile boolean enabled = true;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupPath
    private String path;
    private final Set<String> imagesInFlight = new LinkedHashSet<String>();

    RebNode(Reb reb) {
        this.reb = reb;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    FitsService getFitsService() {
        return this.fitsService;
    }

    Location getLocation() {
        return Location.of((String)this.reb.getFullName());
    }

    Reb getReb() {
        return this.reb;
    }

    public void build() {
        this.agentStateService.registerState(ImageHandlingState.class, "The Image Handling State for a Reb", (Object)this);
        this.agentStateService.updateAgentComponentState((Object)this, new Enum[]{ImageHandlingState.IDLE});
    }

    @ConfigurationParameterChanger(propertyName="enabled")
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateState(enabled ? ImageHandlingState.IDLE : ImageHandlingState.DISABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateState(ImageHandlingState state) {
        Object object = this.agentStateService.getStateLock();
        synchronized (object) {
            ImageHandlingState currentState = this.getState();
            switch (state) {
                case DISABLED: {
                    if (currentState == ImageHandlingState.IDLE) break;
                    return;
                }
                case STREAMING: 
                case READING: {
                    if (currentState == ImageHandlingState.IDLE) break;
                    throw new RuntimeException("Illegal state transition. Cannot go to " + (Object)((Object)state) + " while in state: " + (Object)((Object)this.getState()));
                }
            }
            this.agentStateService.updateAgentComponentState((Object)this, new Enum[]{state});
            if (state == ImageHandlingState.IDLE && !this.isEnabled()) {
                this.agentStateService.updateAgentComponentState((Object)this, new Enum[]{ImageHandlingState.DISABLED});
            }
        }
    }

    private ImageHandlingState getState() {
        return (ImageHandlingState)this.agentStateService.getComponentState(this.path, ImageHandlingState.class);
    }

    synchronized void incrementImageCount(String name) {
        boolean wasEmpty = this.imagesInFlight.isEmpty();
        this.imagesInFlight.add(name);
        if (wasEmpty) {
            this.updateState(ImageHandlingState.READING);
        }
    }

    synchronized void decrementImageCount(String name) {
        boolean removed = this.imagesInFlight.remove(name);
        if (removed && this.imagesInFlight.isEmpty()) {
            this.updateState(ImageHandlingState.IDLE);
        }
    }
}

