/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelUtils;

public class SequencerInfo {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*(.*)");
    @Argument(required=true, usage="Input (.seq) File")
    private File file;
    @Option(name="-P", usage="Set a parameter, use -P parameter=value [-P anotherParameter=anotherValue]")
    private List<String> parameters = new ArrayList<String>();

    public static void main(String[] args) throws FileNotFoundException, IOException {
        new SequencerInfo().doMain(args);
    }

    private void doMain(String[] args) throws FileNotFoundException, IOException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            this.compile();
        }
        catch (IllegalArgumentException | CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java Compiler [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
        }
    }

    private void compile() throws FileNotFoundException, IOException, CmdLineException {
        FPGA2Model compiled;
        FileInputStream input = new FileInputStream(this.file);
        Iterator<Map.Entry<String, Integer>> iterator = null;
        try {
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            compiled = builder.compileFile(input);
        }
        catch (Throwable builder) {
            iterator = builder;
            throw builder;
        }
        finally {
            if (input != null) {
                if (iterator != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable builder) {
                        ((Throwable)((Object)iterator)).addSuppressed(builder);
                    }
                } else {
                    ((InputStream)input).close();
                }
            }
        }
        System.out.printf("Compilation of %s at %s\n", this.file, new Date());
        System.out.printf("Checksum: %08x\n", compiled.computeCheckSum());
        HashMap addressMap = new HashMap();
        for (Map.Entry<String, Integer> entry : compiled.getFunctionAddresses().entrySet()) {
            addressMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Integer> entry : compiled.getSubroutineAddresses().entrySet()) {
            addressMap.put(entry.getKey(), entry.getValue());
        }
        Map<Integer, String> inverseAddressMap = addressMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (String p : this.parameters) {
            Matcher matcher = PARAMETER_PATTERN.matcher(p);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Illegal parameter: " + p);
            }
            if (!compiled.getPointerMap().containsKey(matcher.group(1))) {
                throw new IllegalArgumentException("Unknown parameter: " + matcher.group(1));
            }
            String key = matcher.group(1);
            String value = matcher.group(2);
            FPGA2Model.PointerInfo.PointerKind kind = compiled.getPointerMap().get(key).getKind();
            if (kind == FPGA2Model.PointerInfo.PointerKind.FUNCTION || kind == FPGA2Model.PointerInfo.PointerKind.SUBROUTINE) {
                Integer address = (Integer)addressMap.get(value);
                if (address == null) {
                    throw new IllegalArgumentException("Invalid parameter value: " + p);
                }
                parameterMap.put(key, value);
                continue;
            }
            Integer result = Integer.parseInt(value);
            parameterMap.put(key, result);
        }
        System.out.printf("\nParameters\n    %-20s %8s %-20s %-20s %-20s\n", "Name", "Address", "Type", "Value", "Default Value");
        compiled.getPointers().stream().forEach(i -> {
            FPGA2Model.PointerInfo.PointerKind kind = i.getKind();
            String value = kind == FPGA2Model.PointerInfo.PointerKind.FUNCTION || kind == FPGA2Model.PointerInfo.PointerKind.SUBROUTINE ? (String)inverseAddressMap.get(i.getValue()) : String.format("%d", i.getValue());
            if (parameterMap.containsKey(i.getName())) {
                System.out.printf("    %-20s %8x %-20s %-20s %-20s\n", new Object[]{i.getName(), i.getOffset(), i.getKind(), parameterMap.get(i.getName()), value});
            } else {
                System.out.printf("    %-20s %8x %-20s %-20s\n", new Object[]{i.getName(), i.getOffset(), i.getKind(), value});
            }
        });
        FPGA2ModelUtils utils = new FPGA2ModelUtils(compiled, parameterMap);
        System.out.printf("\nMains\n    %-20s %-8s %-20s %-20s\n", "Name", "Address", "Time (ns)", "Pixels");
        compiled.getMainAddresses().entrySet().stream().forEach(i -> {
            FPGA2ModelUtils.LongWithInfinity nanos = utils.getNanosForRoutine((String)i.getKey());
            FPGA2ModelUtils.LongWithInfinity pixels = utils.getPixelsForRoutine((String)i.getKey());
            System.out.printf("    %-20s %08x %-20s %-20s\n", i.getKey(), i.getValue(), nanos, pixels.isZero() ? "" : pixels);
        });
        System.out.printf("\nSubroutines\n    %-20s %-8s %-20s %-20s\n", "Name", "Address", "Time (ns)", "Pixels");
        compiled.getSubroutineAddresses().entrySet().stream().forEach(f -> {
            FPGA2ModelUtils.LongWithInfinity nanos = utils.getNanosForRoutine((String)f.getKey());
            FPGA2ModelUtils.LongWithInfinity pixels = utils.getPixelsForRoutine((String)f.getKey());
            System.out.printf("    %-20s %08x %-20s %-20s\n", f.getKey(), f.getValue(), nanos, pixels.isZero() ? "" : pixels);
        });
        System.out.printf("\nFunctions\n    %-20s %-8s %-20s %-20s\n", "Name", "Address", "Time (ns)", "Pixels");
        compiled.getFunctionAddresses().entrySet().stream().forEach(f -> {
            long nanos = utils.getNanosForFunction((String)f.getKey());
            FPGA2ModelUtils.PixelCount pixels = utils.getPixelsForFunction((String)f.getKey());
            System.out.printf("    %-20s %08x %-,20d %-20s\n", f.getKey(), f.getValue(), nanos, pixels);
        });
    }
}

