/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.lsst.ccs.web.rest.file.server.MyConfiguration;

public class TestServer {
    private Path tempDir = Files.createTempDirectory("RestServer", new FileAttribute[0]);
    private final URI serverURI;
    private final HttpServer httpServer;

    public TestServer() throws URISyntaxException, IOException {
        MyConfiguration rc = new MyConfiguration();
        rc.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(TestServer.this.tempDir).to(Path.class);
            }
        });
        this.serverURI = new URI("http://localhost:9999/");
        this.httpServer = JdkHttpServerFactory.createHttpServer((URI)this.serverURI.resolve("rest"), (ResourceConfig)rc, (boolean)true);
    }

    public final void cleanFiles() throws IOException {
        Files.walk(this.tempDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).filter(p -> p != this.tempDir).map(Path::toFile).forEach(File::delete);
    }

    public void shutdown() throws IOException {
        this.httpServer.stop(0);
        this.cleanFiles();
        Files.delete(this.tempDir);
    }

    public URI getServerURI() {
        return this.serverURI;
    }
}

