/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.jvnet.hk2.annotations.Optional;
import org.lsst.ccs.web.rest.file.server.VersionedFile;

@Path(value="version")
@Produces(value={"application/json"})
public class VersionedFileServer {
    @Inject
    @Optional
    private java.nio.file.Path baseDir;

    @Context
    public void setServletContext(ServletContext context) throws IOException {
        String initParameter;
        if (context != null && (initParameter = context.getInitParameter("org.lsst.ccs.web.rest.file.server.baseDir")) != null) {
            this.baseDir = Paths.get(initParameter, new String[0]);
        }
        if (this.baseDir == null) {
            this.baseDir = Paths.get("/home/tonyj/ConfigTest/", new String[0]);
        }
    }

    @GET
    @Path(value="info/{filePath: .*}")
    public Object info(@PathParam(value="filePath") String filePath) throws IOException {
        int[] versions;
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile cf = new VersionedFile(path);
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        result.put("default", Integer.valueOf(cf.getDefaultVersion()));
        result.put("latest", Integer.valueOf(cf.getLatestVersion()));
        ArrayList fileVersions = new ArrayList();
        for (int version : versions = cf.getVersions()) {
            LinkedHashMap<String, Object> fileVersion = new LinkedHashMap<String, Object>();
            fileVersion.put("version", version);
            java.nio.file.Path child = cf.getPathForVersion(version);
            BasicFileAttributes fileAttributes = Files.getFileAttributeView(child, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            fileVersion.put("name", child.getFileName().toString());
            fileVersion.put("size", fileAttributes.size());
            fileVersion.put("lastModified", fileAttributes.lastModifiedTime().toMillis());
            fileVersion.put("fileKey", fileAttributes.fileKey().toString());
            fileVersion.put("isDirectory", fileAttributes.isDirectory());
            fileVersion.put("isOther", fileAttributes.isOther());
            fileVersion.put("isRegularFile", fileAttributes.isRegularFile());
            fileVersion.put("isSymbolicLink", fileAttributes.isSymbolicLink());
            fileVersion.put("lastAccessTime", fileAttributes.lastAccessTime().toMillis());
            fileVersion.put("creationTime", fileAttributes.creationTime().toMillis());
            fileVersion.put("mimeType", Files.probeContentType(child));
            fileVersions.add(fileVersion);
        }
        result.put("versions", fileVersions);
        return result;
    }

    @GET
    @Path(value="download/{filePath: .*}")
    @Produces(value={"application/octet-stream"})
    public Response file(@PathParam(value="filePath") String filePath, @QueryParam(value="version") String version) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        int versionNumber = this.computeVersion(vf, version);
        java.nio.file.Path fileToReturn = vf.getPathForVersion(versionNumber);
        StreamingOutput fileStream = output -> {
            byte[] data = Files.readAllBytes(fileToReturn);
            output.write(data);
            output.flush();
        };
        return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + path.getFileName())).header("version", (Object)versionNumber).build();
    }

    private int computeVersion(VersionedFile vf, String version) throws IOException, NumberFormatException {
        int versionNumber;
        if (version == null || version.isEmpty()) {
            version = "default";
        }
        switch (version) {
            case "default": {
                versionNumber = vf.getDefaultVersion();
                break;
            }
            case "latest": {
                versionNumber = vf.getLatestVersion();
                break;
            }
            default: {
                versionNumber = Integer.parseInt(version);
            }
        }
        return versionNumber;
    }

    @GET
    @Path(value="diff/{filePath: .*}")
    @Produces(value={"application/octet-stream"})
    public Response diff(@PathParam(value="filePath") String filePath, @QueryParam(value="v1") String v1, @QueryParam(value="v2") String v2) throws IOException, DiffException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        int iv1 = this.computeVersion(vf, v1);
        int iv2 = this.computeVersion(vf, v2);
        java.nio.file.Path file1 = vf.getPathForVersion(iv1);
        java.nio.file.Path file2 = vf.getPathForVersion(iv2);
        List<String> lines1 = Files.readAllLines(file1);
        List<String> lines2 = Files.readAllLines(file2);
        Patch diff = DiffUtils.diff(lines1, lines2);
        List generateUnifiedDiff = UnifiedDiffUtils.generateUnifiedDiff((String)(vf.getFileName() + ";" + v1), (String)(vf.getFileName() + ";" + v2), lines1, (Patch)diff, (int)2);
        StreamingOutput fileStream = output -> {
            for (String dLines : generateUnifiedDiff) {
                output.write(dLines.getBytes());
                output.write(10);
                output.flush();
            }
        };
        return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + path.getFileName())).build();
    }

    @PUT
    @Path(value="set/{filePath: .*}")
    @Consumes(value={"application/json"})
    public Object set(@PathParam(value="filePath") String filePath, int defaultVersion) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        vf.setDefaultVersion(defaultVersion);
        return this.info(filePath);
    }

    @POST
    @Path(value="upload/{filePath: .*}")
    @Consumes(value={"application/octet-stream"})
    public Object upload(@PathParam(value="filePath") String filePath, byte[] content) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        if (VersionedFile.isVersionedFile(path)) {
            VersionedFile vf = new VersionedFile(path);
            int newVersion = vf.addVersion(content);
            return Collections.singletonMap("version", newVersion);
        }
        VersionedFile vf = VersionedFile.create(path, content);
        return Collections.singletonMap("version", 1);
    }

    @DELETE
    @Path(value="deleteFile/{filePath: .*}")
    public Response deleteFile(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        vf.delete();
        return Response.ok().build();
    }
}

