/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.jvnet.hk2.annotations.Optional;
import org.lsst.ccs.web.rest.file.server.VersionedFile;

@Path(value="/")
@Produces(value={"application/json"})
public class FileServer {
    @Inject
    @Optional
    private java.nio.file.Path baseDir;

    @Context
    public void setServletContext(ServletContext context) throws IOException {
        String initParameter;
        if (context != null && (initParameter = context.getInitParameter("org.lsst.ccs.web.rest.file.server.baseDir")) != null) {
            this.baseDir = Paths.get(initParameter, new String[0]);
        }
        if (this.baseDir == null) {
            this.baseDir = Paths.get("/home/tonyj/ConfigTest/", new String[0]);
        }
    }

    @GET
    @Path(value="list")
    public Object list() throws IOException {
        return this.list("");
    }

    @GET
    @Path(value="list/{filePath: .*}")
    public Object list(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        Map<String, Object> fileProperties = this.info(filePath);
        boolean isDirectory = Files.isDirectory(file, new LinkOption[0]);
        if (isDirectory) {
            Stream<java.nio.file.Path> listFiles = Files.list(file);
            ArrayList result = new ArrayList();
            listFiles.forEach(child -> {
                try {
                    LinkedHashMap<String, Object> childProperties = new LinkedHashMap<String, Object>();
                    childProperties.put("name", child.getFileName().toString());
                    childProperties.put("size", Files.size(child));
                    childProperties.put("lastModified", Files.getLastModifiedTime(child, new LinkOption[0]).toMillis());
                    childProperties.put("isVersionedFile", VersionedFile.isVersionedFile(child));
                    result.add(childProperties);
                }
                catch (IOException x) {
                    System.out.println(x.getMessage());
                }
            });
            result.sort((o1, o2) -> o1.get("name").toString().compareTo(o2.get("name").toString()));
            fileProperties.put("children", result);
        }
        return fileProperties;
    }

    @GET
    @Path(value="info/{filePath: .*}")
    public Map<String, Object> info(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        BasicFileAttributes fileAttributes = Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        LinkedHashMap<String, Object> fileProperties = new LinkedHashMap<String, Object>();
        fileProperties.put("name", file.getFileName().toString());
        fileProperties.put("size", fileAttributes.size());
        fileProperties.put("lastModified", fileAttributes.lastModifiedTime().toMillis());
        fileProperties.put("fileKey", fileAttributes.fileKey().toString());
        fileProperties.put("isDirectory", fileAttributes.isDirectory());
        fileProperties.put("isOther", fileAttributes.isOther());
        fileProperties.put("isRegularFile", fileAttributes.isRegularFile());
        fileProperties.put("isSymbolicLink", fileAttributes.isSymbolicLink());
        fileProperties.put("lastAccessTime", fileAttributes.lastAccessTime().toMillis());
        fileProperties.put("creationTime", fileAttributes.creationTime().toMillis());
        fileProperties.put("mimeType", Files.probeContentType(file));
        fileProperties.put("isVersionedFile", VersionedFile.isVersionedFile(file));
        return fileProperties;
    }

    @GET
    @Path(value="download/{filePath: .*}")
    @Produces(value={"application/octet-stream"})
    public Response file(@PathParam(value="filePath") String filePath) {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        if (file.toFile().canRead()) {
            StreamingOutput fileStream = output -> {
                byte[] data = Files.readAllBytes(file);
                output.write(data);
                output.flush();
            };
            return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + file.getFileName())).build();
        }
        return Response.status((int)404, (String)("File not readable: " + file)).build();
    }

    @GET
    @Path(value="createDirectory/{filePath: .*}")
    public Response createDirectory(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        Files.createDirectory(file, new FileAttribute[0]);
        return Response.ok().build();
    }

    @GET
    @Path(value="createFile/{filePath: .*}")
    public Response createFile(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        Files.createFile(file, new FileAttribute[0]);
        return Response.ok().build();
    }

    @GET
    @Path(value="move/{filePath: .*}")
    public Response move(@PathParam(value="filePath") String source, @QueryParam(value="target") String target) throws IOException {
        java.nio.file.Path sourcePath = this.baseDir.resolve(source);
        java.nio.file.Path targetPath = this.baseDir.resolve(target);
        Files.move(sourcePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="deleteFile/{filePath: .*}")
    public Response deleteFile(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        Files.delete(file);
        return Response.ok().build();
    }

    @POST
    @Path(value="upload/{filePath: .*}")
    @Consumes(value={"application/octet-stream"})
    public Response upload(@PathParam(value="filePath") String filePath, byte[] content) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE_NEW);){
            out.write(content);
        }
        return Response.ok().build();
    }
}

