/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import java.util.Arrays;
import org.lsst.sal.SALTelemetry;

public class AirTurbulenceTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float[] speed;
    private final float[] speedStdDev;
    private final float speedMagnitude;
    private final float speedMaxMagnitude;
    private final float sonicTemperature;
    private final float sonicTemperatureStdDev;
    private final String location;

    public AirTurbulenceTelemetry(String sensorName, double timestamp, float[] speed, float[] speedStdDev, float speedMagnitude, float speedMaxMagnitude, float sonicTemperature, float sonicTemperatureStdDev, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.speed = speed;
        this.speedStdDev = speedStdDev;
        this.speedMagnitude = speedMagnitude;
        this.speedMaxMagnitude = speedMaxMagnitude;
        this.sonicTemperature = sonicTemperature;
        this.sonicTemperatureStdDev = sonicTemperatureStdDev;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float[] getSpeed() {
        return this.speed;
    }

    public float[] getSpeedStdDev() {
        return this.speedStdDev;
    }

    public float getSpeedMagnitude() {
        return this.speedMagnitude;
    }

    public float getSpeedMaxMagnitude() {
        return this.speedMaxMagnitude;
    }

    public float getSonicTemperature() {
        return this.sonicTemperature;
    }

    public float getSonicTemperatureStdDev() {
        return this.sonicTemperatureStdDev;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "AirTurbulenceTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", speed=" + Arrays.toString(this.speed) + ", speedStdDev=" + Arrays.toString(this.speedStdDev) + ", speedMagnitude=" + this.speedMagnitude + ", speedMaxMagnitude=" + this.speedMaxMagnitude + ", sonicTemperature=" + this.sonicTemperature + ", sonicTemperatureStdDev=" + this.sonicTemperatureStdDev + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float[] speed;
        private float[] speedStdDev;
        private float speedMagnitude;
        private float speedMaxMagnitude;
        private float sonicTemperature;
        private float sonicTemperatureStdDev;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder speed(float[] speed) {
            this.speed = speed;
            return this;
        }

        public Builder speedStdDev(float[] speedStdDev) {
            this.speedStdDev = speedStdDev;
            return this;
        }

        public Builder speedMagnitude(float speedMagnitude) {
            this.speedMagnitude = speedMagnitude;
            return this;
        }

        public Builder speedMaxMagnitude(float speedMaxMagnitude) {
            this.speedMaxMagnitude = speedMaxMagnitude;
            return this;
        }

        public Builder sonicTemperature(float sonicTemperature) {
            this.sonicTemperature = sonicTemperature;
            return this;
        }

        public Builder sonicTemperatureStdDev(float sonicTemperatureStdDev) {
            this.sonicTemperatureStdDev = sonicTemperatureStdDev;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public AirTurbulenceTelemetry build() {
            return new AirTurbulenceTelemetry(this.sensorName, this.timestamp, this.speed, this.speedStdDev, this.speedMagnitude, this.speedMaxMagnitude, this.sonicTemperature, this.sonicTemperatureStdDev, this.location);
        }
    }
}

