/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import java.util.Arrays;
import org.lsst.sal.SALTelemetry;

public class RaritanTelemetry
extends SALTelemetry {
    private final String systemDescription;
    private final float inletRmsCurrent;
    private final float inletUnbalancedCurrent;
    private final float inletRmsVoltage;
    private final float inletActivePower;
    private final float inletApparentPower;
    private final float inletPowerFactor;
    private final float inletActiveEnergy;
    private final float inletFrequency;
    private final float inletUnbalancedVoltage;
    private final float inletUnbalancedLineLineVoltage;
    private final float[] outletRmsCurrent;
    private final float[] outletRmsVoltage;
    private final float[] outletActivePower;
    private final float[] outletApparentPower;
    private final float[] outletPowerFactor;
    private final float[] outletActiveEnergy;
    private final boolean[] outletOnOff;
    private final float[] outletFrequency;
    private final String sensorName;

    public RaritanTelemetry(String systemDescription, float inletRmsCurrent, float inletUnbalancedCurrent, float inletRmsVoltage, float inletActivePower, float inletApparentPower, float inletPowerFactor, float inletActiveEnergy, float inletFrequency, float inletUnbalancedVoltage, float inletUnbalancedLineLineVoltage, float[] outletRmsCurrent, float[] outletRmsVoltage, float[] outletActivePower, float[] outletApparentPower, float[] outletPowerFactor, float[] outletActiveEnergy, boolean[] outletOnOff, float[] outletFrequency, String sensorName) {
        this.systemDescription = systemDescription;
        this.inletRmsCurrent = inletRmsCurrent;
        this.inletUnbalancedCurrent = inletUnbalancedCurrent;
        this.inletRmsVoltage = inletRmsVoltage;
        this.inletActivePower = inletActivePower;
        this.inletApparentPower = inletApparentPower;
        this.inletPowerFactor = inletPowerFactor;
        this.inletActiveEnergy = inletActiveEnergy;
        this.inletFrequency = inletFrequency;
        this.inletUnbalancedVoltage = inletUnbalancedVoltage;
        this.inletUnbalancedLineLineVoltage = inletUnbalancedLineLineVoltage;
        this.outletRmsCurrent = outletRmsCurrent;
        this.outletRmsVoltage = outletRmsVoltage;
        this.outletActivePower = outletActivePower;
        this.outletApparentPower = outletApparentPower;
        this.outletPowerFactor = outletPowerFactor;
        this.outletActiveEnergy = outletActiveEnergy;
        this.outletOnOff = outletOnOff;
        this.outletFrequency = outletFrequency;
        this.sensorName = sensorName;
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    public float getInletRmsCurrent() {
        return this.inletRmsCurrent;
    }

    public float getInletUnbalancedCurrent() {
        return this.inletUnbalancedCurrent;
    }

    public float getInletRmsVoltage() {
        return this.inletRmsVoltage;
    }

    public float getInletActivePower() {
        return this.inletActivePower;
    }

    public float getInletApparentPower() {
        return this.inletApparentPower;
    }

    public float getInletPowerFactor() {
        return this.inletPowerFactor;
    }

    public float getInletActiveEnergy() {
        return this.inletActiveEnergy;
    }

    public float getInletFrequency() {
        return this.inletFrequency;
    }

    public float getInletUnbalancedVoltage() {
        return this.inletUnbalancedVoltage;
    }

    public float getInletUnbalancedLineLineVoltage() {
        return this.inletUnbalancedLineLineVoltage;
    }

    public float[] getOutletRmsCurrent() {
        return this.outletRmsCurrent;
    }

    public float[] getOutletRmsVoltage() {
        return this.outletRmsVoltage;
    }

    public float[] getOutletActivePower() {
        return this.outletActivePower;
    }

    public float[] getOutletApparentPower() {
        return this.outletApparentPower;
    }

    public float[] getOutletPowerFactor() {
        return this.outletPowerFactor;
    }

    public float[] getOutletActiveEnergy() {
        return this.outletActiveEnergy;
    }

    public boolean[] getOutletOnOff() {
        return this.outletOnOff;
    }

    public float[] getOutletFrequency() {
        return this.outletFrequency;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public String toString() {
        return "RaritanTelemetry{systemDescription=" + this.systemDescription + ", inletRmsCurrent=" + this.inletRmsCurrent + ", inletUnbalancedCurrent=" + this.inletUnbalancedCurrent + ", inletRmsVoltage=" + this.inletRmsVoltage + ", inletActivePower=" + this.inletActivePower + ", inletApparentPower=" + this.inletApparentPower + ", inletPowerFactor=" + this.inletPowerFactor + ", inletActiveEnergy=" + this.inletActiveEnergy + ", inletFrequency=" + this.inletFrequency + ", inletUnbalancedVoltage=" + this.inletUnbalancedVoltage + ", inletUnbalancedLineLineVoltage=" + this.inletUnbalancedLineLineVoltage + ", outletRmsCurrent=" + Arrays.toString(this.outletRmsCurrent) + ", outletRmsVoltage=" + Arrays.toString(this.outletRmsVoltage) + ", outletActivePower=" + Arrays.toString(this.outletActivePower) + ", outletApparentPower=" + Arrays.toString(this.outletApparentPower) + ", outletPowerFactor=" + Arrays.toString(this.outletPowerFactor) + ", outletActiveEnergy=" + Arrays.toString(this.outletActiveEnergy) + ", outletOnOff=" + Arrays.toString(this.outletOnOff) + ", outletFrequency=" + Arrays.toString(this.outletFrequency) + ", sensorName=" + this.sensorName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemDescription;
        private float inletRmsCurrent;
        private float inletUnbalancedCurrent;
        private float inletRmsVoltage;
        private float inletActivePower;
        private float inletApparentPower;
        private float inletPowerFactor;
        private float inletActiveEnergy;
        private float inletFrequency;
        private float inletUnbalancedVoltage;
        private float inletUnbalancedLineLineVoltage;
        private float[] outletRmsCurrent;
        private float[] outletRmsVoltage;
        private float[] outletActivePower;
        private float[] outletApparentPower;
        private float[] outletPowerFactor;
        private float[] outletActiveEnergy;
        private boolean[] outletOnOff;
        private float[] outletFrequency;
        private String sensorName;

        private Builder() {
        }

        public Builder systemDescription(String systemDescription) {
            this.systemDescription = systemDescription;
            return this;
        }

        public Builder inletRmsCurrent(float inletRmsCurrent) {
            this.inletRmsCurrent = inletRmsCurrent;
            return this;
        }

        public Builder inletUnbalancedCurrent(float inletUnbalancedCurrent) {
            this.inletUnbalancedCurrent = inletUnbalancedCurrent;
            return this;
        }

        public Builder inletRmsVoltage(float inletRmsVoltage) {
            this.inletRmsVoltage = inletRmsVoltage;
            return this;
        }

        public Builder inletActivePower(float inletActivePower) {
            this.inletActivePower = inletActivePower;
            return this;
        }

        public Builder inletApparentPower(float inletApparentPower) {
            this.inletApparentPower = inletApparentPower;
            return this;
        }

        public Builder inletPowerFactor(float inletPowerFactor) {
            this.inletPowerFactor = inletPowerFactor;
            return this;
        }

        public Builder inletActiveEnergy(float inletActiveEnergy) {
            this.inletActiveEnergy = inletActiveEnergy;
            return this;
        }

        public Builder inletFrequency(float inletFrequency) {
            this.inletFrequency = inletFrequency;
            return this;
        }

        public Builder inletUnbalancedVoltage(float inletUnbalancedVoltage) {
            this.inletUnbalancedVoltage = inletUnbalancedVoltage;
            return this;
        }

        public Builder inletUnbalancedLineLineVoltage(float inletUnbalancedLineLineVoltage) {
            this.inletUnbalancedLineLineVoltage = inletUnbalancedLineLineVoltage;
            return this;
        }

        public Builder outletRmsCurrent(float[] outletRmsCurrent) {
            this.outletRmsCurrent = outletRmsCurrent;
            return this;
        }

        public Builder outletRmsVoltage(float[] outletRmsVoltage) {
            this.outletRmsVoltage = outletRmsVoltage;
            return this;
        }

        public Builder outletActivePower(float[] outletActivePower) {
            this.outletActivePower = outletActivePower;
            return this;
        }

        public Builder outletApparentPower(float[] outletApparentPower) {
            this.outletApparentPower = outletApparentPower;
            return this;
        }

        public Builder outletPowerFactor(float[] outletPowerFactor) {
            this.outletPowerFactor = outletPowerFactor;
            return this;
        }

        public Builder outletActiveEnergy(float[] outletActiveEnergy) {
            this.outletActiveEnergy = outletActiveEnergy;
            return this;
        }

        public Builder outletOnOff(boolean[] outletOnOff) {
            this.outletOnOff = outletOnOff;
            return this;
        }

        public Builder outletFrequency(float[] outletFrequency) {
            this.outletFrequency = outletFrequency;
            return this;
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public RaritanTelemetry build() {
            return new RaritanTelemetry(this.systemDescription, this.inletRmsCurrent, this.inletUnbalancedCurrent, this.inletRmsVoltage, this.inletActivePower, this.inletApparentPower, this.inletPowerFactor, this.inletActiveEnergy, this.inletFrequency, this.inletUnbalancedVoltage, this.inletUnbalancedLineLineVoltage, this.outletRmsCurrent, this.outletRmsVoltage, this.outletActivePower, this.outletApparentPower, this.outletPowerFactor, this.outletActiveEnergy, this.outletOnOff, this.outletFrequency, this.sensorName);
        }
    }
}

