/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import java.util.Arrays;
import org.lsst.sal.SALTelemetry;

public class SpectrumAnalyzerTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float startFrequency;
    private final float stopFrequency;
    private final float[] spectrum;
    private final String location;

    public SpectrumAnalyzerTelemetry(String sensorName, double timestamp, float startFrequency, float stopFrequency, float[] spectrum, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.startFrequency = startFrequency;
        this.stopFrequency = stopFrequency;
        this.spectrum = spectrum;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float getStartFrequency() {
        return this.startFrequency;
    }

    public float getStopFrequency() {
        return this.stopFrequency;
    }

    public float[] getSpectrum() {
        return this.spectrum;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "SpectrumAnalyzerTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", startFrequency=" + this.startFrequency + ", stopFrequency=" + this.stopFrequency + ", spectrum=" + Arrays.toString(this.spectrum) + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float startFrequency;
        private float stopFrequency;
        private float[] spectrum;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder startFrequency(float startFrequency) {
            this.startFrequency = startFrequency;
            return this;
        }

        public Builder stopFrequency(float stopFrequency) {
            this.stopFrequency = stopFrequency;
            return this;
        }

        public Builder spectrum(float[] spectrum) {
            this.spectrum = spectrum;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public SpectrumAnalyzerTelemetry build() {
            return new SpectrumAnalyzerTelemetry(this.sensorName, this.timestamp, this.startFrequency, this.stopFrequency, this.spectrum, this.location);
        }
    }
}

