/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import java.util.Arrays;
import org.lsst.sal.SALTelemetry;

public class ParticleMeasurementsTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float[] particleSizes;
    private final float[] matterConcentration;
    private final float[] numberConcentration;
    private final float typicalParticleSize;
    private final String location;

    public ParticleMeasurementsTelemetry(String sensorName, double timestamp, float[] particleSizes, float[] matterConcentration, float[] numberConcentration, float typicalParticleSize, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.particleSizes = particleSizes;
        this.matterConcentration = matterConcentration;
        this.numberConcentration = numberConcentration;
        this.typicalParticleSize = typicalParticleSize;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float[] getParticleSizes() {
        return this.particleSizes;
    }

    public float[] getMatterConcentration() {
        return this.matterConcentration;
    }

    public float[] getNumberConcentration() {
        return this.numberConcentration;
    }

    public float getTypicalParticleSize() {
        return this.typicalParticleSize;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "ParticleMeasurementsTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", particleSizes=" + Arrays.toString(this.particleSizes) + ", matterConcentration=" + Arrays.toString(this.matterConcentration) + ", numberConcentration=" + Arrays.toString(this.numberConcentration) + ", typicalParticleSize=" + this.typicalParticleSize + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float[] particleSizes;
        private float[] matterConcentration;
        private float[] numberConcentration;
        private float typicalParticleSize;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder particleSizes(float[] particleSizes) {
            this.particleSizes = particleSizes;
            return this;
        }

        public Builder matterConcentration(float[] matterConcentration) {
            this.matterConcentration = matterConcentration;
            return this;
        }

        public Builder numberConcentration(float[] numberConcentration) {
            this.numberConcentration = numberConcentration;
            return this;
        }

        public Builder typicalParticleSize(float typicalParticleSize) {
            this.typicalParticleSize = typicalParticleSize;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public ParticleMeasurementsTelemetry build() {
            return new ParticleMeasurementsTelemetry(this.sensorName, this.timestamp, this.particleSizes, this.matterConcentration, this.numberConcentration, this.typicalParticleSize, this.location);
        }
    }
}

