/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.ess.telemetry;

import org.lsst.sal.SALTelemetry;

public class AirFlowTelemetry
extends SALTelemetry {
    private final String sensorName;
    private final double timestamp;
    private final float direction;
    private final float directionStdDev;
    private final float speed;
    private final float speedStdDev;
    private final float maxSpeed;
    private final String location;

    public AirFlowTelemetry(String sensorName, double timestamp, float direction, float directionStdDev, float speed, float speedStdDev, float maxSpeed, String location) {
        this.sensorName = sensorName;
        this.timestamp = timestamp;
        this.direction = direction;
        this.directionStdDev = directionStdDev;
        this.speed = speed;
        this.speedStdDev = speedStdDev;
        this.maxSpeed = maxSpeed;
        this.location = location;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public float getDirection() {
        return this.direction;
    }

    public float getDirectionStdDev() {
        return this.directionStdDev;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getSpeedStdDev() {
        return this.speedStdDev;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "AirFlowTelemetry{sensorName=" + this.sensorName + ", timestamp=" + this.timestamp + ", direction=" + this.direction + ", directionStdDev=" + this.directionStdDev + ", speed=" + this.speed + ", speedStdDev=" + this.speedStdDev + ", maxSpeed=" + this.maxSpeed + ", location=" + this.location + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sensorName;
        private double timestamp;
        private float direction;
        private float directionStdDev;
        private float speed;
        private float speedStdDev;
        private float maxSpeed;
        private String location;

        private Builder() {
        }

        public Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public Builder timestamp(double timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder direction(float direction) {
            this.direction = direction;
            return this;
        }

        public Builder directionStdDev(float directionStdDev) {
            this.directionStdDev = directionStdDev;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder speedStdDev(float speedStdDev) {
            this.speedStdDev = speedStdDev;
            return this;
        }

        public Builder maxSpeed(float maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public AirFlowTelemetry build() {
            return new AirFlowTelemetry(this.sensorName, this.timestamp, this.direction, this.directionStdDev, this.speed, this.speedStdDev, this.maxSpeed, this.location);
        }
    }
}

