/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.util.LinkedHashMap;
import java.util.Map;

class EnumValues {
    private final String name;
    private final Map<String, String> values;
    private boolean hasExplicitValues = false;

    public EnumValues(String name, String values) {
        this.name = name;
        this.values = this.parseString(values);
    }

    public EnumValues(String nameAndValues) {
        this.name = nameAndValues.split("_")[0];
        String remainingValues = nameAndValues.replace(this.name + "_", "");
        this.values = this.parseString(remainingValues);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getEnumConstants() {
        return this.values;
    }

    public boolean hasExplicitValues() {
        return this.hasExplicitValues;
    }

    private Map<String, String> parseString(String values) {
        String[] pairs;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String pair : pairs = values.split(",")) {
            String[] keyValue = pair.split("=");
            String key = keyValue[0].trim();
            if (keyValue.length == 2) {
                String value = keyValue[1].trim();
                result.put(key, value);
                this.hasExplicitValues = true;
                continue;
            }
            if (keyValue.length != 1) continue;
            result.put(key, null);
        }
        return result;
    }
}

