/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.lsst.sal.SALEnum;
import org.lsst.sal.codegen.CodegenMojo;
import org.lsst.sal.codegen.EnumValues;
import org.lsst.sal.codegen.JavaFromXML;

final class ClassInfo {
    private final String className;
    private final Map<String, TypeName> convertedVariableNamesAndTypesMap;
    private final Map<String, TypeName> superClassArguments = new LinkedHashMap<String, TypeName>();
    private final Map<String, Variable> variableNamesAndCounts = new LinkedHashMap<String, Variable>();
    private String packageName;
    private final String superClassName;
    private final Map<String, Variable> originalVariableNamesAndTypesMap;
    private final Map<String, TypeSpec> globalEnumerations;
    private final Map<String, TypeSpec> perItemEnumerations;
    private final JavaFromXML.ClassType classType;
    private final String salClassName;
    private boolean isInherited = false;

    ClassInfo(String rawClassName, String className, CodegenMojo mojo, String packageName, Map<String, Variable> variableNamesAndTypesMap, Map<String, EnumValues> globalEnumMap, Map<String, EnumValues> perItemEnumMap, JavaFromXML.ClassType classType, String salClassName) {
        boolean isState;
        this.className = ClassInfo.computeClassName(className, classType);
        this.packageName = ClassInfo.computePackageName(classType, packageName);
        this.superClassName = ClassInfo.computeSuperClass(classType, mojo);
        this.globalEnumerations = ClassInfo.computeEnumerations(globalEnumMap);
        this.perItemEnumerations = ClassInfo.computeEnumerations(perItemEnumMap);
        this.originalVariableNamesAndTypesMap = variableNamesAndTypesMap;
        this.convertedVariableNamesAndTypesMap = this.convertToTypeMap(variableNamesAndTypesMap);
        this.classType = classType;
        this.salClassName = salClassName;
        boolean bl = isState = classType == JavaFromXML.ClassType.STATE;
        if (isState) {
            String type = className.replace("Event", "").replace("Detailed", "");
            this.perItemEnumerations.clear();
            if (!perItemEnumMap.isEmpty()) {
                EnumValues theEnum = perItemEnumMap.values().iterator().next();
                TypeSpec enumerationCode = ClassInfo.createEnumerationCode(type, theEnum);
                this.perItemEnumerations.put("substate", enumerationCode);
                this.convertedVariableNamesAndTypesMap.remove("summaryState");
                this.convertedVariableNamesAndTypesMap.put("substate", (TypeName)ClassName.bestGuess((String)type));
            }
        }
    }

    boolean checkIfCanInherit(List<ClassInfo> possibleSuperClasses) {
        for (ClassInfo info : possibleSuperClasses) {
            if (!info.className.equals(this.className) || !info.originalVariableNamesAndTypesMap.equals(this.originalVariableNamesAndTypesMap)) continue;
            this.packageName = info.packageName;
            this.isInherited = true;
            this.originalVariableNamesAndTypesMap.forEach((name, type) -> {
                if (this.perItemEnumerations.containsKey(name)) {
                    ClassName typeName = ClassName.get((String)(this.packageName + "." + this.className), (String)JavaFromXML.capitalize(type.getType()), (String[])new String[0]);
                    if (type.isJavaArray()) {
                        typeName = ArrayTypeName.of((TypeName)typeName);
                    }
                    this.convertedVariableNamesAndTypesMap.put((String)name, (TypeName)typeName);
                }
            });
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, TypeName> getVariableNamesAndTypesMap() {
        return this.convertedVariableNamesAndTypesMap;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public Set<TypeSpec> getPerItemEnumerations() {
        return new HashSet<TypeSpec>(this.perItemEnumerations.values());
    }

    JavaFromXML.ClassType getClassType() {
        return this.classType;
    }

    private static String computeClassName(String className, JavaFromXML.ClassType classType) {
        return switch (classType) {
            case JavaFromXML.ClassType.STATE, JavaFromXML.ClassType.EVENT -> className + "Event";
            case JavaFromXML.ClassType.TELEMETRY -> className + "Telemetry";
            case JavaFromXML.ClassType.COMMAND -> className + "Command";
            default -> className;
        };
    }

    private static String computePackageName(JavaFromXML.ClassType classType, String basePackageName) {
        return switch (classType) {
            case JavaFromXML.ClassType.STATE -> basePackageName + ".states";
            case JavaFromXML.ClassType.EVENT -> basePackageName + ".event";
            case JavaFromXML.ClassType.TELEMETRY -> basePackageName + ".telemetry";
            case JavaFromXML.ClassType.COMMAND -> basePackageName + ".command";
            default -> basePackageName;
        };
    }

    private static String computeSuperClass(JavaFromXML.ClassType classType, CodegenMojo mojo) {
        switch (classType) {
            case STATE: {
                return mojo.getStateParent();
            }
            case EVENT: {
                return mojo.getEventParent();
            }
            case TELEMETRY: {
                return mojo.getTelemetryParent();
            }
        }
        return mojo.getCommandParent();
    }

    private Map<String, TypeName> convertToTypeMap(Map<String, Variable> variableNamesAndTypesMap) {
        LinkedHashMap<String, TypeName> result = new LinkedHashMap<String, TypeName>();
        variableNamesAndTypesMap.forEach((name, type) -> {
            result.put((String)name, this.mapVariableTypeToJava((Variable)type, (String)name));
            this.variableNamesAndCounts.put((String)name, (Variable)type);
        });
        return result;
    }

    private TypeName mapVariableTypeToJava(Variable variable, String name) {
        String type = variable.getType();
        Object typeName = type.equals("string") ? TypeName.get(String.class) : (type.equals("long long") ? TypeName.LONG : (type.contains("long") ? TypeName.INT : (this.perItemEnumerations.containsKey(name) ? ClassName.get((String)(this.packageName + "." + this.className), (String)JavaFromXML.capitalize(type), (String[])new String[0]) : TypeVariableName.get((String)type))));
        if (variable.isJavaArray()) {
            typeName = ArrayTypeName.of((TypeName)typeName);
        }
        return typeName;
    }

    String getClassTypeName() {
        String whatClass = "";
        if (this.classType == JavaFromXML.ClassType.TELEMETRY) {
            whatClass = "telemetry";
        }
        if (this.classType == JavaFromXML.ClassType.COMMAND) {
            whatClass = "command";
        }
        if (this.classType == JavaFromXML.ClassType.EVENT) {
            whatClass = "event";
        }
        if (this.classType == JavaFromXML.ClassType.STATE) {
            whatClass = "state";
        }
        return whatClass;
    }

    String getSALClassName() {
        return this.salClassName;
    }

    Map<String, TypeName> getSuperClassArguments() {
        return this.superClassArguments;
    }

    Map<String, TypeName> getConstructorArguments() {
        LinkedHashMap<String, TypeName> map = new LinkedHashMap<String, TypeName>();
        map.putAll(this.superClassArguments);
        map.putAll(this.convertedVariableNamesAndTypesMap);
        return map;
    }

    private static Map<String, TypeSpec> computeEnumerations(Map<String, EnumValues> enumMap) {
        LinkedHashMap<String, TypeSpec> result = new LinkedHashMap<String, TypeSpec>();
        enumMap.forEach((name, values) -> result.put((String)name, ClassInfo.createEnumerationCode(values)));
        return result;
    }

    static TypeSpec createEnumerationCode(EnumValues values) {
        return ClassInfo.createEnumerationCode(JavaFromXML.capitalize(values.getName()), values);
    }

    static TypeSpec createEnumerationCode(String name, EnumValues values) {
        if (values.hasExplicitValues()) {
            TypeSpec.Builder enumerationBuilder = TypeSpec.enumBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SALEnum.class);
            for (Map.Entry<String, String> value : values.getEnumConstants().entrySet()) {
                enumerationBuilder.addEnumConstant(value.getKey(), TypeSpec.anonymousClassBuilder((String)"$L", (Object[])new Object[]{value.getValue()}).build());
            }
            FieldSpec intField = FieldSpec.builder((TypeName)TypeName.INT, (String)"value", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            enumerationBuilder.addField(intField);
            MethodSpec constructor = MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)TypeName.INT, (String)"value", (Modifier[])new Modifier[0]).build()).addStatement("this.$N = $N", new Object[]{"value", "value"}).build();
            enumerationBuilder.addMethod(constructor);
            MethodSpec getValue = MethodSpec.methodBuilder((String)"getSALValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement("return this.$N", new Object[]{"value"}).addAnnotation(Override.class).build();
            enumerationBuilder.addMethod(getValue);
            MethodSpec forValue = MethodSpec.methodBuilder((String)"forSALValue").addParameter(ParameterSpec.builder((TypeName)TypeName.INT, (String)"value", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.bestGuess((String)name)).beginControlFlow("for ($1T state : $1T.values())", new Object[]{ClassName.bestGuess((String)name)}).beginControlFlow("if (state.getSALValue() == value)", new Object[0]).addStatement("return state", new Object[0]).endControlFlow().endControlFlow().addStatement("return null", new Object[0]).build();
            enumerationBuilder.addMethod(forValue);
            return enumerationBuilder.build();
        }
        TypeSpec.Builder enumerationBuilder = TypeSpec.enumBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SALEnum.class);
        for (Map.Entry<String, String> value : values.getEnumConstants().entrySet()) {
            enumerationBuilder.addEnumConstant(value.getKey());
        }
        return enumerationBuilder.build();
    }

    boolean isEnumeration(String name) {
        return this.perItemEnumerations.containsKey(name);
    }

    boolean isArray(String name) {
        return this.convertedVariableNamesAndTypesMap.get(name) instanceof ArrayTypeName;
    }

    TypeSpec getEnumerationType(String name) {
        return this.perItemEnumerations.get(name);
    }

    int getCount(String name) {
        return this.variableNamesAndCounts.get(name).getCount();
    }

    int getSize(String name) {
        return this.variableNamesAndCounts.get(name).getSize();
    }

    String getGetter(String name) {
        TypeName type = this.convertedVariableNamesAndTypesMap.get(name);
        if (type == null) {
            type = TypeName.INT;
        }
        String stem = type.toString().equalsIgnoreCase("boolean") ? "is" : "get";
        return stem + JavaFromXML.capitalize(name);
    }

    boolean isInherited() {
        return this.isInherited;
    }

    static class Variable {
        private final int count;
        private final int size;
        private final String type;
        private final boolean isJavaArray;

        public Variable(String type, int count, int size, boolean isJavaArray) {
            this.type = type.replace("unsigned", "").trim();
            this.count = count;
            this.size = size;
            this.isJavaArray = isJavaArray;
        }

        public int getCount() {
            return this.count;
        }

        public String getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isJavaArray() {
            return this.isJavaArray;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Variable other = (Variable)obj;
            if (this.isJavaArray != other.isJavaArray) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + Objects.hashCode(this.type);
            hash = 23 * hash + (this.isJavaArray ? 1 : 0);
            return hash;
        }
    }
}

