/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.lang.model.element.Modifier;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.JavaFromXML;

public class TestWriter {
    private final String commandSendReceiveTestFile = "CommandSendReceiveTest";
    private final String eventSendReceiveTestFile = "EventSendReceiveTest";
    private final String telemetrySendReceiveTestFile = "TelemetrySendReceiveTest";
    private final Random random = new Random(12345L);
    private final List<ClassInfo> classInfos;
    private final String basePackageName;
    private final String salFile;

    TestWriter(List<ClassInfo> classInfos, String basePackageName, String salFile) {
        this.classInfos = classInfos;
        this.basePackageName = basePackageName;
        this.salFile = salFile;
    }

    void writeTestFiles(String testCodePath) throws IOException {
        this.generateBoilerPlate(testCodePath, ClassName.get((String)this.basePackageName, (String)"CommandSendReceiveTest", (String[])new String[0]), JavaFromXML.ClassType.COMMAND);
        this.generateBoilerPlate(testCodePath, ClassName.get((String)this.basePackageName, (String)"EventSendReceiveTest", (String[])new String[0]), JavaFromXML.ClassType.EVENT);
        this.generateBoilerPlate(testCodePath, ClassName.get((String)this.basePackageName, (String)"TelemetrySendReceiveTest", (String[])new String[0]), JavaFromXML.ClassType.TELEMETRY);
    }

    private void generateBoilerPlate(String outputPath, ClassName generatedClass, JavaFromXML.ClassType testType) throws IOException {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        ClassName sal = ClassName.get(SAL.class);
        FieldSpec salField = FieldSpec.builder((TypeName)sal, (String)"sal", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PRIVATE}).build();
        fields.add(salField);
        ClassName executor = ClassName.get(ExecutorService.class);
        FieldSpec executorField = FieldSpec.builder((TypeName)executor, (String)"executor", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PRIVATE}).build();
        fields.add(executorField);
        methods.add(this.createSetupMethod(executorField, salField));
        methods.add(this.createTeardownMethod(executorField, salField));
        MethodSpec testSendReceive = TestWriter.createSendReceiveMethod(executorField, salField, testType);
        methods.add(testSendReceive);
        for (ClassInfo info : this.classInfos) {
            if (info.getClassType() != testType) continue;
            ClassName testClass = ClassName.get((String)info.getPackageName(), (String)info.getClassName(), (String[])new String[0]);
            MethodSpec.Builder testCaseBuilder = MethodSpec.methodBuilder((String)("sendReceive" + info.getClassName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).addAnnotation(Test.class);
            info.getConstructorArguments().forEach((name, type) -> {
                Object testData;
                if (type.toString().equals("java.lang.String[]")) {
                    type = ClassName.get(String.class);
                }
                if ((testData = this.generateTestData(info, (String)name, (TypeName)type)).toString().contains(".generate")) {
                    testCaseBuilder.addStatement("$1T $2N = " + testData, new Object[]{type, name, TestHelper.class});
                } else if (testData.toString().contains("$3T")) {
                    testCaseBuilder.addStatement("$1T $2N = " + testData, new Object[]{type, name, type instanceof ArrayTypeName ? ((ArrayTypeName)type).componentType : type});
                } else {
                    testCaseBuilder.addStatement("$1T $2N = " + testData, new Object[]{type, name});
                }
            });
            testCaseBuilder.addStatement("$T $N = $N(new $T($N))", new Object[]{testSendReceive.returnType, "item", testSendReceive, testClass, String.join((CharSequence)",", info.getConstructorArguments().keySet())}).addStatement("$T.assertTrue($N instanceof $T)", new Object[]{Assert.class, "item", testClass}).addStatement("$T $N = ($T) $N", new Object[]{testClass, "item_", testClass, "item"});
            info.getConstructorArguments().forEach((name, type) -> {
                if (type.toString().equals("java.lang.String[]")) {
                    type = ClassName.get(String.class);
                }
                String assertEquals = "assertEquals";
                if (type instanceof ArrayTypeName) {
                    assertEquals = "assertArrayEquals";
                    type = ((ArrayTypeName)type).componentType;
                }
                if ("float".equals(type.toString()) || "double".equals(type.toString())) {
                    testCaseBuilder.addStatement("$T.$N($N,$N.$N(),1e-6f)", new Object[]{Assert.class, assertEquals, name, "item_", info.getGetter((String)name)});
                } else {
                    testCaseBuilder.addStatement("$T.$N($N,$N.$N())", new Object[]{Assert.class, assertEquals, name, "item_", info.getGetter((String)name)});
                }
            });
            methods.add(testCaseBuilder.build());
        }
        TypeSpec classDefinition = TypeSpec.classBuilder((String)generatedClass.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addFields(fields).addMethods(methods).build();
        JavaFile javaFile = JavaFile.builder((String)generatedClass.packageName(), (TypeSpec)classDefinition).skipJavaLangImports(true).build();
        javaFile.writeTo(new File(outputPath));
    }

    private Object generateTestData(ClassInfo info, String name, TypeName type) {
        String letters = "abcdefghijklmnopqrstuvwxyz";
        boolean isArray = type instanceof ArrayTypeName;
        if (isArray) {
            TypeName arrayType = ((ArrayTypeName)type).componentType;
            int arraySize = info.getCount(name);
            switch (arrayType.toString()) {
                case "double": 
                case "float": 
                case "int": 
                case "long": 
                case "short": {
                    return "$3T.generate" + JavaFromXML.capitalize(arrayType.toString()) + "Array(" + arraySize + "," + this.random.nextInt() + ")";
                }
            }
            ArrayList<String> array = new ArrayList<String>();
            for (int i = 0; i < arraySize; ++i) {
                array.add(this.generateTestData(info, name, arrayType).toString());
            }
            return "{" + String.join((CharSequence)",", array) + "}";
        }
        switch (type.toString()) {
            case "short": 
            case "int": 
            case "long": {
                return this.random.nextInt(1000);
            }
            case "double": 
            case "float": {
                return this.random.nextFloat() + "f";
            }
            case "boolean": {
                return this.random.nextBoolean();
            }
            case "java.lang.String": {
                int n = this.random.nextInt(info.getSize(name) + 1);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    int l = this.random.nextInt(letters.length());
                    sb.append(letters.substring(l, l + 1));
                }
                return "\"" + sb + "\"";
            }
        }
        if (info.isEnumeration(name)) {
            TypeSpec typeSpec = info.getEnumerationType(name);
            int enumSize = typeSpec.enumConstants.size();
            int enumSelected = this.random.nextInt(enumSize);
            return "$3T." + new ArrayList(typeSpec.enumConstants.keySet()).get(enumSelected);
        }
        return "null";
    }

    private static MethodSpec createSendReceiveMethod(FieldSpec executorField, FieldSpec salField, JavaFromXML.ClassType testType) {
        Class<SALReceivedCommand> getterReturnType;
        String getterMethodName;
        Class<SALCommand> testClass;
        String sendMethodName = switch (testType) {
            case JavaFromXML.ClassType.COMMAND -> {
                testClass = SALCommand.class;
                getterMethodName = "getNextCommand";
                getterReturnType = SALReceivedCommand.class;
                yield "issueCommand";
            }
            case JavaFromXML.ClassType.TELEMETRY -> {
                testClass = SALTelemetry.class;
                getterMethodName = "getTelemetry";
                getterReturnType = SALTelemetry.class;
                yield "sendTelemetry";
            }
            default -> {
                testClass = SALEvent.class;
                getterMethodName = "getNextEvent";
                getterReturnType = SALEvent.class;
                yield "logEvent";
            }
        };
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"testSendReceive").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(testClass, "item", new Modifier[0]).returns(testClass).addException(InterruptedException.class).addException(SALException.class).addException(ExecutionException.class).addException(TimeoutException.class).addStatement("$T $N = $N.submit(() -> $N.$N($T.ofSeconds(10)))", new Object[]{ParameterizedTypeName.get(Future.class, (Type[])new Type[]{getterReturnType}), "future", executorField, "sal", getterMethodName, Duration.class}).beginControlFlow("try", new Object[0]);
        if (testType == JavaFromXML.ClassType.COMMAND) {
            methodBuilder.addStatement("$T $N = $N.$N($N)", new Object[]{SALCommandResponse.class, "response", salField, sendMethodName, "item"}).addStatement("$T $N = $N.get(10, $T.SECONDS)", new Object[]{SALReceivedCommand.class, "result", "future", TimeUnit.class}).addStatement("$N.acknowledgeCommand($T.ofSeconds(3))", new Object[]{"result", Duration.class}).addStatement("$N.reportComplete()", new Object[]{"result"}).addStatement("int rc = $N.waitForCompletion($T.ofSeconds(1))", new Object[]{"response", Duration.class}).addStatement("$T.assertEquals(303,rc)", new Object[]{Assert.class}).addStatement("return $N.getCommand()", new Object[]{"result"});
        } else {
            methodBuilder.addStatement("$N.$N($N)", new Object[]{"sal", sendMethodName, "item"}).addStatement("return $N.get(10, $T.SECONDS)", new Object[]{"future", TimeUnit.class});
        }
        return methodBuilder.nextControlFlow("finally", new Object[0]).addStatement("$N.cancel(true)", new Object[]{"future"}).endControlFlow().build();
    }

    private MethodSpec createTeardownMethod(FieldSpec executorField, FieldSpec salField) {
        return MethodSpec.methodBuilder((String)"tearDownClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addException(InterruptedException.class).addException(SALException.class).addAnnotation(AfterClass.class).addStatement("$N.shutdown()", new Object[]{executorField}).addStatement("$N.awaitTermination(10, $T.SECONDS)", new Object[]{executorField, TimeUnit.class}).addStatement("$N.close()", new Object[]{salField}).build();
    }

    private MethodSpec createSetupMethod(FieldSpec executorField, FieldSpec salField) {
        return MethodSpec.methodBuilder((String)"setUpClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(BeforeClass.class).addStatement("$N = $N.create()", new Object[]{salField, this.salFile}).addStatement("$N = $T.newFixedThreadPool(1)", new Object[]{executorField, ClassName.get(Executors.class)}).build();
    }
}

