/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.lsst.sal.SALEnum;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.EnumValues;

class JavaClassWriter {
    private final ClassInfo classInfo;

    JavaClassWriter(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    static void writeEnumeration(String outputPath, String packageName, Map.Entry<String, EnumValues> enumeration) throws IOException {
        TypeSpec enumerationCode = ClassInfo.createEnumerationCode(enumeration.getValue());
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)enumerationCode).skipJavaLangImports(true).build();
        javaFile.writeTo(new File(outputPath));
    }

    void writeClasses(String outputPath) throws IOException {
        ArrayList fields = new ArrayList();
        this.classInfo.getVariableNamesAndTypesMap().forEach((name, type) -> {
            if (type.toString().equals("java.lang.String[]")) {
                type = ClassName.get(String.class);
            }
            fields.add(FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        });
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.constructConstructor());
        this.classInfo.getVariableNamesAndTypesMap().forEach((name, type) -> methods.add(this.constructGetter((String)name, (TypeName)type)));
        methods.add(this.constructToStringMethod());
        TypeSpec.Builder classDefinitionBuilder = TypeSpec.classBuilder((String)this.classInfo.getClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.bestGuess((String)this.classInfo.getSuperClassName())).addTypes(this.classInfo.getPerItemEnumerations());
        if (this.classInfo.getConstructorArguments().size() > 5) {
            TypeSpec builder = this.constructBuilder();
            classDefinitionBuilder.addTypes(Collections.singleton(builder));
            methods.add(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns((TypeName)ClassName.bestGuess((String)builder.name)).addStatement("return new $N()", new Object[]{builder}).build());
        }
        if (this.classInfo.getSuperClassName().contains("State") && this.classInfo.getPerItemEnumerations().isEmpty()) {
            methods.add(this.constructGetSubstateMethod());
        }
        TypeSpec classDefinition = classDefinitionBuilder.addMethods(methods).addFields(fields).build();
        JavaFile javaFile = JavaFile.builder((String)this.classInfo.getPackageName(), (TypeSpec)classDefinition).skipJavaLangImports(true).build();
        javaFile.writeTo(new File(outputPath));
    }

    private MethodSpec constructGetter(String name, TypeName type) {
        if (type.toString().equals("java.lang.String[]")) {
            type = ClassName.get(String.class);
        }
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)this.classInfo.getGetter(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(type).addStatement("return $L", new Object[]{name});
        if (name.equals("substate")) {
            getterBuilder.addAnnotation(Override.class);
        }
        return getterBuilder.build();
    }

    private MethodSpec constructToStringMethod() {
        CodeBlock.Builder toStringCodeBuilder = CodeBlock.builder().add("return $S + ", new Object[]{this.classInfo.getClassName() + "{"});
        String delimiter = "";
        for (Map.Entry<String, TypeName> var : this.classInfo.getVariableNamesAndTypesMap().entrySet()) {
            String name = var.getKey();
            TypeName type = var.getValue();
            if (type.toString().equals("java.lang.String[]")) {
                type = ClassName.get(String.class);
            }
            if (type instanceof ArrayTypeName) {
                toStringCodeBuilder.add("$S + $T.toString($N) +$Z", new Object[]{delimiter + name + "=", ClassName.get(Arrays.class), name});
            } else {
                toStringCodeBuilder.add("$S + $N +$Z", new Object[]{delimiter + name + "=", name});
            }
            delimiter = ", ";
        }
        CodeBlock toStringCode = toStringCodeBuilder.add("$S", new Object[]{"}"}).build();
        return MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement(toStringCode).build();
    }

    private MethodSpec constructConstructor() {
        ArrayList parameters = new ArrayList();
        this.classInfo.getConstructorArguments().forEach((name, type) -> {
            if (type.toString().equals("java.lang.String[]")) {
                type = ClassName.get(String.class);
            }
            parameters.add(ParameterSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[0]).build());
        });
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameters(parameters);
        if (!this.classInfo.getSuperClassArguments().isEmpty()) {
            constructorBuilder.addStatement("super ($N)", new Object[]{String.join((CharSequence)",", this.classInfo.getSuperClassArguments().keySet())});
        }
        this.classInfo.getVariableNamesAndTypesMap().entrySet().forEach(var -> {
            String name = (String)var.getKey();
            constructorBuilder.addStatement("this.$1L = $1L", new Object[]{name});
        });
        return constructorBuilder.build();
    }

    private TypeSpec constructBuilder() {
        ArrayList fields = new ArrayList();
        this.classInfo.getConstructorArguments().forEach((name, type) -> {
            if (type.toString().equals("java.lang.String[]")) {
                type = ClassName.get(String.class);
            }
            fields.add(FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        });
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        ClassName builderType = ClassName.bestGuess((String)"Builder");
        ClassName parent = ClassName.bestGuess((String)this.classInfo.getClassName());
        this.classInfo.getConstructorArguments().forEach((arg_0, arg_1) -> JavaClassWriter.lambda$constructBuilder$5(methods, (TypeName)builderType, arg_0, arg_1));
        CodeBlock.Builder buildCodeBuilder = CodeBlock.builder().add("return new $L(", new Object[]{parent});
        String delimiter = "";
        for (String name2 : this.classInfo.getConstructorArguments().keySet()) {
            buildCodeBuilder.add("$L$N", new Object[]{delimiter, name2});
            delimiter = ", ";
        }
        buildCodeBuilder.add(")", new Object[0]);
        methods.add(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)parent).addStatement(buildCodeBuilder.build()).build());
        TypeSpec classDefinition = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addMethods(methods).addFields(fields).build();
        return classDefinition;
    }

    private MethodSpec constructGetSubstateMethod() {
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)"getSubstate").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(SALEnum.class)).addStatement("return null", new Object[0]).addAnnotation(Override.class);
        return getterBuilder.build();
    }

    private static /* synthetic */ void lambda$constructBuilder$5(List methods, TypeName builderType, String name, TypeName type) {
        if (type.toString().equals("java.lang.String[]")) {
            type = ClassName.get(String.class);
        }
        methods.add(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(type, name, new Modifier[0]).returns(builderType).addStatement("this.$1L = $1L", new Object[]{name}).addStatement("return this", new Object[0]).build());
    }
}

