/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.CodegenMojo;
import org.lsst.sal.codegen.EnumValues;
import org.lsst.sal.codegen.JavaFromXML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLReader {
    private final CodegenMojo mojo;

    XMLReader(CodegenMojo mojo) {
        this.mojo = mojo;
    }

    XMLReaderResult read(DocumentBuilder builder, URL xmlURL, String packageName) throws SAXException, IOException {
        try (InputStream in = xmlURL.openStream();){
            Document document = builder.parse(new InputSource(in));
            XMLReaderResult xMLReaderResult = this.read(document, packageName);
            return xMLReaderResult;
        }
    }

    private XMLReaderResult read(Document document, String packageName) {
        Element root = document.getDocumentElement();
        if ("SALObjects".equals(root.getTagName())) {
            XMLReaderResult result = new XMLReaderResult();
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (!(item instanceof Element)) continue;
                Element element = (Element)item;
                result.addAll(this.handleObjectsForElement(element, packageName));
            }
            return result;
        }
        return this.handleObjectsForElement(root, packageName);
    }

    private XMLReaderResult handleObjectsForElement(Element element, String packageName) throws NumberFormatException, DOMException {
        JavaFromXML.ClassType classType = element.getTagName().contains("Event") ? JavaFromXML.ClassType.EVENT : (element.getTagName().contains("Telemetry") ? JavaFromXML.ClassType.TELEMETRY : JavaFromXML.ClassType.COMMAND);
        return this.handleObjectsOfClass(element, classType, packageName);
    }

    private XMLReaderResult handleObjectsOfClass(Element document, JavaFromXML.ClassType classType, String packageName) throws NumberFormatException, DOMException {
        ArrayList<ClassInfo> classInfoCollection = new ArrayList<ClassInfo>();
        LinkedHashMap<String, EnumValues> globalEnumMap = new LinkedHashMap<String, EnumValues>();
        List<Element> globalEnumList = this.getImmediateChildrenByTagName(document, "Enumeration");
        for (Element globalEnum : globalEnumList) {
            String enumType = globalEnum.getTextContent().trim();
            EnumValues enumValues = new EnumValues(enumType);
            globalEnumMap.put(enumValues.getName(), enumValues);
        }
        NodeList salClassNodes = document.getElementsByTagName(classType.getTag());
        for (int i = 0; i < salClassNodes.getLength(); ++i) {
            LinkedHashMap<String, ClassInfo.Variable> variableNamesAndTypesMap = new LinkedHashMap<String, ClassInfo.Variable>();
            LinkedHashMap<String, EnumValues> perItemEnumMap = new LinkedHashMap<String, EnumValues>();
            Node node = salClassNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element eClass = (Element)node;
            NodeList topicList = eClass.getElementsByTagName("EFDB_Topic");
            if (topicList.getLength() > 1) {
                System.out.println("More than one EFDB_Topic(Class Name) in class - incorrect xml \n");
                System.exit(0);
            }
            Object className = topicList.item(0).getTextContent().trim();
            String rawClassName = ((String)className).split("_", 2)[0] + "." + ((String)className).split("_", 2)[1];
            className = ((String)className).split("_", 2)[1];
            className = ((String)className).replace("logevent_", "");
            className = ((String)(className = ((String)className).replace("command_", ""))).contains("ccs") ? ((String)className).replace("ccs", "CCS") : ((String)className).substring(0, 1).toUpperCase() + ((String)className).substring(1);
            JavaFromXML.ClassType thisClassType = classType;
            if (((String)className).endsWith("State")) {
                thisClassType = JavaFromXML.ClassType.STATE;
            }
            NodeList itemList = eClass.getElementsByTagName("item");
            for (int iI = 0; iI < itemList.getLength(); ++iI) {
                int count;
                Node node2 = itemList.item(iI);
                if (!(node2 instanceof Element)) continue;
                Element eI = (Element)node2;
                NodeList efdbNameList = eI.getElementsByTagName("EFDB_Name");
                NodeList idlTypeList = eI.getElementsByTagName("IDL_Type");
                NodeList idlSizeList = eI.getElementsByTagName("IDL_Size");
                NodeList enumerationList = eI.getElementsByTagName("Enumeration");
                NodeList countList = eI.getElementsByTagName("Count");
                NodeList isJavaArrayList = eI.getElementsByTagName("IsJavaArray");
                if (efdbNameList.getLength() > 1 || idlTypeList.getLength() > 1 || enumerationList.getLength() > 1 || efdbNameList.getLength() != idlTypeList.getLength()) {
                    System.out.println(" There should only be 1 EFDB_Name, IDL_Type, Enumeration List in an item \n ");
                    System.out.println(" Every EFDB_Name should have a corresponding IDL_Type");
                    System.exit(0);
                }
                boolean isJavaArray = (count = Integer.parseInt(countList.item(0).getTextContent().trim())) > 1 || isJavaArrayList.getLength() > 0;
                int size = 1;
                if (idlSizeList.getLength() >= 1) {
                    size = Integer.parseInt(idlSizeList.item(0).getTextContent().trim());
                }
                if (((String)className).endsWith("SummaryState")) {
                    perItemEnumMap.put(efdbNameList.item(0).getTextContent().trim(), new EnumValues("SummaryState", "DISABLED,ENABLED,FAULT,OFFLINE,STANDBY"));
                }
                if (enumerationList.getLength() > 0) {
                    String enumType = efdbNameList.item(0).getTextContent().trim();
                    perItemEnumMap.put(efdbNameList.item(0).getTextContent().trim(), new EnumValues(enumType, enumerationList.item(0).getTextContent().trim()));
                    variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new ClassInfo.Variable(enumType, count, size, isJavaArray));
                    continue;
                }
                if (efdbNameList.getLength() <= 0 || enumerationList.getLength() >= 1) continue;
                String type = idlTypeList.item(0).getTextContent().trim();
                if (classType.equals((Object)JavaFromXML.ClassType.COMMAND) && efdbNameList.item(0).getTextContent().trim().equals("value") && type.equals("boolean")) continue;
                variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new ClassInfo.Variable(type, count, size, isJavaArray));
            }
            classInfoCollection.add(new ClassInfo(rawClassName, (String)className, this.mojo, packageName, variableNamesAndTypesMap, globalEnumMap, perItemEnumMap, thisClassType, rawClassName));
        }
        return new XMLReaderResult(classInfoCollection, globalEnumMap);
    }

    private List<Element> getImmediateChildrenByTagName(Element parent, String tagName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !tagName.equals(node.getNodeName())) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    static class XMLReaderResult {
        private final List<ClassInfo> classInfos;
        private final Map<String, EnumValues> globalEnumerations;

        private XMLReaderResult(List<ClassInfo> classInfos, Map<String, EnumValues> globalEnumerations) {
            this.classInfos = classInfos;
            this.globalEnumerations = globalEnumerations;
        }

        XMLReaderResult() {
            this.classInfos = new ArrayList<ClassInfo>();
            this.globalEnumerations = new LinkedHashMap<String, EnumValues>();
        }

        List<ClassInfo> getClasses() {
            return this.classInfos;
        }

        Map<String, EnumValues> getGlobalEnumerations() {
            return this.globalEnumerations;
        }

        void addAll(XMLReaderResult result) {
            this.classInfos.addAll(result.getClasses());
            this.globalEnumerations.putAll(result.getGlobalEnumerations());
        }
    }
}

