/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.CodegenMojo;
import org.lsst.sal.codegen.JavaClassWriter;
import org.lsst.sal.codegen.SalWriter;
import org.lsst.sal.codegen.TestWriter;
import org.lsst.sal.codegen.XMLReader;
import org.xml.sax.SAXException;

public class JavaFromXML {
    private final CodegenMojo mojo;

    JavaFromXML(CodegenMojo mojo) {
        this.mojo = mojo;
    }

    void execute() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        XMLReader reader = new XMLReader(this.mojo);
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        for (URL xmlURL : this.mojo.getXMLs()) {
            classInfos.addAll(reader.read(builder, xmlURL, this.mojo.getBasePackageName()));
        }
        List<URL> xmlInheritURLs = this.mojo.getInheritXMLs();
        ArrayList<ClassInfo> inheritClassInfos = new ArrayList<ClassInfo>();
        for (URL xmlURL : xmlInheritURLs) {
            inheritClassInfos.addAll(reader.read(builder, xmlURL, this.mojo.getInheritPackageName()));
        }
        for (ClassInfo info : classInfos) {
            info.checkIfCanInherit(inheritClassInfos);
        }
        for (ClassInfo info : classInfos) {
            if (info.isInherited()) continue;
            JavaClassWriter writer = new JavaClassWriter(info);
            writer.writeClasses(this.mojo.getOutputDir().getAbsolutePath());
        }
        SalWriter salWriter = new SalWriter(classInfos, this.mojo);
        salWriter.writeSalFile();
        TestWriter testGenerator = new TestWriter(classInfos, this.mojo.getBasePackageName(), this.mojo.getSalMain());
        testGenerator.writeTestFiles(this.mojo.getTestOutputDir().getAbsolutePath());
    }

    static String capitalize(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    static enum ClassType {
        TELEMETRY("SALTelemetry"),
        STATE("SALEvent"),
        EVENT("SALEvent"),
        COMMAND("SALCommand");

        private final String tag;

        private ClassType(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

