/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.lsst.ccs.camera.sal.xml.maker.MakeAllXML;
import org.lsst.ccs.camera.sal.xml.util.ChecksumExtractorUtils;
import org.lsst.sal.codegen.JavaFromXML;
import org.lsst.sal.codegen.JavaMainWriter;
import org.xml.sax.SAXException;

@Mojo(name="codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CodegenMojo
extends AbstractMojo {
    @Parameter(property="project", defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="salMain", defaultValue="SALMain")
    private String salMain;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-sources/sal-code")
    private File outputDir;
    @Parameter(property="outputTestDir", defaultValue="${project.build.directory}/generated-test-sources/sal-test")
    private File outputTestDir;
    @Parameter(property="outputResourcesDir", defaultValue="${project.build.directory}/generated-sources/sal-resources")
    private File outputResourcesDir;
    @Parameter(property="xmlPath", defaultValue="${env.SIMPLESAL_XMLPATH}")
    private File xmlPath;
    @Parameter(property="xmlFiles")
    private String[] xmlFiles;
    @Parameter(property="xmlInheritFiles")
    private String[] xmlInheritFiles;
    @Parameter(property="basePackageName", defaultValue="org.lsst.sal.camera")
    private String basePackageName;
    @Parameter(property="inheritPackageName", defaultValue="org.lsst.sal.camera")
    private String inheritPackageName;
    @Parameter(property="managerClassName", defaultValue="org.lsst.sal.SAL_MTCamera")
    private String managerClassName;
    @Parameter(property="telemetryParent", defaultValue="org.lsst.sal.SALTelemetry")
    private String telemetryParent;
    @Parameter(property="stateParent", defaultValue="org.lsst.sal.SALStateChangeEvent")
    private String stateParent;
    @Parameter(property="eventParent", defaultValue="org.lsst.sal.SALEvent")
    private String eventParent;
    @Parameter(property="commandParent", defaultValue="org.lsst.sal.SALCommand")
    private String commandParent;
    @Parameter(property="salFile", defaultValue="salFile.sal")
    private String salFile;

    static CodegenMojo createTest() {
        CodegenMojo mojo = new CodegenMojo();
        mojo.basePackageName = "org.lsst.sal.cccamera";
        mojo.commandParent = "org.lsst.sal.camera.CameraCommand";
        mojo.eventParent = "org.lsst.sal.camera.CameraEvent";
        mojo.stateParent = "org.lsst.sal.camera.CameraStateChangeEvent";
        mojo.telemetryParent = "org.lsst.sal.camera.CameraTelemetry";
        mojo.salFile = "cccamera.sal";
        mojo.managerClassName = "org.lsst.sal.SAL_CCCamera";
        mojo.salMain = "CCCamera";
        mojo.xmlFiles = new String[]{"xml/CCCamera_Commands.xml", "xml/CCCamera_Events.xml", "xml/CCCamera_Telemetry.xml", "xml/CCCamera_Generics.xml"};
        mojo.inheritPackageName = "org.lsst.sal.camera";
        mojo.xmlInheritFiles = new String[]{"xml/MTCamera_Commands.xml", "xml/MTCamera_Events.xml", "xml/MTCamera_Telemetry.xml", "xml/MTCamera_Generics.xml"};
        mojo.xmlPath = null;
        return mojo;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.project.addCompileSourceRoot(this.outputDir.getAbsolutePath());
        this.project.addTestCompileSourceRoot(this.outputTestDir.getAbsolutePath());
        Resource generatedResources = new Resource();
        generatedResources.setDirectory(this.outputResourcesDir.getAbsolutePath());
        this.project.addResource(generatedResources);
        try {
            ChecksumExtractorUtils extractor = new ChecksumExtractorUtils();
            for (URL url : this.getXMLs()) {
                String fileName = url.getFile();
                if (fileName.contains("/")) {
                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                }
                if (!fileName.endsWith("Telemetry.xml") && !fileName.endsWith("Events.xml")) continue;
                InputStream in = url.openStream();
                try {
                    Map extractChecksumsFromInputXMLFile = extractor.extractChecksumsFromSALXMLInputStream(in);
                    Map consistencyCheckCheckSums = MakeAllXML.extractChecksumsForXMLFile((String)fileName);
                    if (consistencyCheckCheckSums.isEmpty()) continue;
                    for (Map.Entry e : extractChecksumsFromInputXMLFile.entrySet()) {
                        String topic = (String)e.getKey();
                        Long check = (Long)e.getValue();
                        Long expectedCheck = (Long)consistencyCheckCheckSums.remove(topic);
                        if (expectedCheck != null && expectedCheck.equals(check)) continue;
                        throw new RuntimeException("Something is wrong with topic " + topic + " checksum " + check + " != " + expectedCheck);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate files due to exception.", e);
        }
        this.outputDir.mkdirs();
        JavaFromXML javaXML = new JavaFromXML(this);
        try {
            javaXML.execute();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not generate Java source code!", e);
        }
        try {
            JavaMainWriter e = new JavaMainWriter(this);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not generate Java source code!", e);
        }
    }

    List<URL> getXMLs() {
        return this.getXMLs(this.xmlFiles);
    }

    List<URL> getInheritXMLs() {
        return this.getXMLs(this.xmlInheritFiles);
    }

    private List<URL> getXMLs(String[] xmlFiles) {
        ArrayList<URL> xmlURLs = new ArrayList<URL>();
        if (xmlFiles != null) {
            for (String xmlFile : xmlFiles) {
                URL resource = null;
                if (resource == null && (resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(xmlFile)) == null) {
                    throw new RuntimeException("XML file not found: " + xmlFile);
                }
                xmlURLs.add(resource);
            }
        }
        return xmlURLs;
    }

    File getOutputDir() {
        return this.outputDir;
    }

    File getTestOutputDir() {
        return this.outputTestDir;
    }

    File getResourceOutputDir() {
        return this.outputResourcesDir;
    }

    String getManagerClassName() {
        return this.managerClassName;
    }

    String getBasePackageName() {
        return this.basePackageName;
    }

    public String getInheritPackageName() {
        return this.inheritPackageName;
    }

    String getSALFileName() {
        return this.salFile;
    }

    String getStateParent() {
        return this.stateParent;
    }

    String getEventParent() {
        return this.eventParent;
    }

    String getTelemetryParent() {
        return this.telemetryParent;
    }

    String getCommandParent() {
        return this.commandParent;
    }

    public String getSalMain() {
        return this.salMain;
    }
}

