/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.CodegenMojo;
import org.lsst.sal.codegen.JavaFromXML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLReader {
    private final CodegenMojo mojo;

    XMLReader(CodegenMojo mojo) {
        this.mojo = mojo;
    }

    List<ClassInfo> read(DocumentBuilder builder, URL xmlURL, String packageName) throws SAXException, IOException {
        try (InputStream in = xmlURL.openStream();){
            Document document = builder.parse(new InputSource(in));
            List<ClassInfo> list = this.read(document, packageName);
            return list;
        }
    }

    private List<ClassInfo> read(Document document, String packageName) {
        ArrayList<ClassInfo> classInfoCollection = new ArrayList<ClassInfo>();
        Element root = document.getDocumentElement();
        if ("SALObjects".equals(root.getTagName())) {
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (!(item instanceof Element)) continue;
                Element element = (Element)item;
                classInfoCollection.addAll(this.handleObjectsForElement(element, packageName));
            }
        } else {
            classInfoCollection.addAll(this.handleObjectsForElement(root, packageName));
        }
        return classInfoCollection;
    }

    private List<ClassInfo> handleObjectsForElement(Element element, String packageName) throws NumberFormatException, DOMException {
        JavaFromXML.ClassType classType = element.getTagName().contains("Event") ? JavaFromXML.ClassType.EVENT : (element.getTagName().contains("Telemetry") ? JavaFromXML.ClassType.TELEMETRY : JavaFromXML.ClassType.COMMAND);
        return this.handleObjectsOfClass(element, classType, packageName);
    }

    private List<ClassInfo> handleObjectsOfClass(Element document, JavaFromXML.ClassType classType, String packageName) throws NumberFormatException, DOMException {
        ArrayList<ClassInfo> classInfoCollection = new ArrayList<ClassInfo>();
        NodeList salClassNodes = document.getElementsByTagName(classType.getTag());
        for (int i = 0; i < salClassNodes.getLength(); ++i) {
            LinkedHashMap<String, ClassInfo.Variable> variableNamesAndTypesMap = new LinkedHashMap<String, ClassInfo.Variable>();
            LinkedHashMap<String, ClassInfo.EnumValues> enumMap = new LinkedHashMap<String, ClassInfo.EnumValues>();
            if (!(salClassNodes.item(i) instanceof Element)) continue;
            Element eClass = (Element)salClassNodes.item(i);
            NodeList topicList = eClass.getElementsByTagName("EFDB_Topic");
            if (topicList.getLength() > 1) {
                System.out.println("More than one EFDB_Topic(Class Name) in class - incorrect xml \n");
                System.exit(0);
            }
            String className = topicList.item(0).getTextContent().trim();
            String rawClassName = className.split("_", 2)[0] + "." + className.split("_", 2)[1];
            className = className.split("_", 2)[1];
            className = className.replace("logevent_", "");
            className = (className = className.replace("command_", "")).contains("ccs") ? className.replace("ccs", "CCS") : className.substring(0, 1).toUpperCase() + className.substring(1);
            JavaFromXML.ClassType thisClassType = classType;
            if (className.endsWith("State")) {
                thisClassType = JavaFromXML.ClassType.STATE;
            }
            NodeList itemList = eClass.getElementsByTagName("item");
            for (int iI = 0; iI < itemList.getLength(); ++iI) {
                int count;
                if (!(itemList.item(iI) instanceof Element)) continue;
                Element eI = (Element)itemList.item(iI);
                NodeList efdbNameList = eI.getElementsByTagName("EFDB_Name");
                NodeList idlTypeList = eI.getElementsByTagName("IDL_Type");
                NodeList idlSizeList = eI.getElementsByTagName("IDL_Size");
                NodeList enumerationList = eI.getElementsByTagName("Enumeration");
                NodeList countList = eI.getElementsByTagName("Count");
                NodeList isJavaArrayList = eI.getElementsByTagName("IsJavaArray");
                if (efdbNameList.getLength() > 1 || idlTypeList.getLength() > 1 || enumerationList.getLength() > 1 || efdbNameList.getLength() != idlTypeList.getLength()) {
                    System.out.println(" There should only be 1 EFDB_Name, IDL_Type, Enumeration List in an item \n ");
                    System.out.println(" Every EFDB_Name should have a corresponding IDL_Type");
                    System.exit(0);
                }
                boolean isJavaArray = (count = Integer.parseInt(countList.item(0).getTextContent().trim())) > 1 || isJavaArrayList.getLength() > 0;
                int size = 1;
                if (idlSizeList.getLength() >= 1) {
                    size = Integer.parseInt(idlSizeList.item(0).getTextContent().trim());
                }
                if (className.endsWith("SummaryState")) {
                    enumMap.put(efdbNameList.item(0).getTextContent().trim(), new ClassInfo.EnumValues("SummaryState", "DISABLED,ENABLED,FAULT,OFFLINE,STANDBY"));
                }
                if (enumerationList.getLength() > 0) {
                    String enumType = efdbNameList.item(0).getTextContent().trim();
                    enumMap.put(efdbNameList.item(0).getTextContent().trim(), new ClassInfo.EnumValues(enumType, enumerationList.item(0).getTextContent().trim()));
                    variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new ClassInfo.Variable(enumType, count, size, isJavaArray));
                    continue;
                }
                if (efdbNameList.getLength() <= 0 || enumerationList.getLength() >= 1) continue;
                String type = idlTypeList.item(0).getTextContent().trim();
                if (classType.equals((Object)JavaFromXML.ClassType.COMMAND) && efdbNameList.item(0).getTextContent().trim().equals("value") && type.equals("boolean")) continue;
                variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new ClassInfo.Variable(type, count, size, isJavaArray));
            }
            classInfoCollection.add(new ClassInfo(rawClassName, className, this.mojo, packageName, variableNamesAndTypesMap, enumMap, thisClassType, rawClassName));
        }
        return classInfoCollection;
    }
}

