/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.CodegenMojo;

class SalWriter {
    private final List<ClassInfo> classInfos;
    private final CodegenMojo mojo;

    SalWriter(List<ClassInfo> classInfos, CodegenMojo mojo) {
        this.classInfos = classInfos;
        this.mojo = mojo;
    }

    void writeSalFile() throws IOException {
        File cameraSalDir = new File(this.mojo.getResourceOutputDir() + "/" + this.mojo.getBasePackageName().replace(".", "/") + "/");
        cameraSalDir.mkdirs();
        try (FileWriter cameraSalFile = new FileWriter(new File(cameraSalDir, this.mojo.getSALFileName()));
             PrintWriter buffer = new PrintWriter(cameraSalFile);){
            this.writeSalFile(buffer);
        }
    }

    void writeSalFile(PrintWriter buffer) {
        buffer.println("# Description of SAL interfaces");
        buffer.println("# Name of manager class");
        buffer.println(this.mojo.getManagerClassName());
        buffer.println("# Remaining lines contain: type simpleSALClassName SALClassName, arguments and types...");
        for (ClassInfo info : this.classInfos) {
            Map<String, TypeName> constructorVariables = info.getConstructorArguments();
            buffer.printf("%s %s.%s %s", info.getClassTypeName(), info.getPackageName(), info.getClassName(), info.getSALClassName());
            constructorVariables.forEach((name, typeName) -> {
                if (info.isEnumeration((String)name)) {
                    typeName = info.isArray((String)name) ? ArrayTypeName.of((TypeName)TypeName.INT) : TypeName.INT;
                }
                if ("substate".equals(name) && "SummaryStateEvent".equals(info.getClassName())) {
                    name = "summaryState";
                }
                if (typeName.toString().equals("java.lang.String[]")) {
                    typeName = ClassName.get(String.class);
                }
                buffer.printf(" %s %s", typeName.toString(), name);
            });
            buffer.println();
        }
    }
}

