/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.lsst.sal.SALEnum;
import org.lsst.sal.codegen.CodegenMojo;
import org.lsst.sal.codegen.JavaFromXML;

final class ClassInfo {
    private final Map<String, Variable> originalVariableNamesAndTypesMap;
    private final String className;
    private final Map<String, TypeName> convertedVariableNamesAndTypesMap;
    private final Map<String, TypeName> superClassArguments = new LinkedHashMap<String, TypeName>();
    private final Map<String, Variable> variableNamesAndCounts = new LinkedHashMap<String, Variable>();
    private String packageName;
    private final String superClassName;
    private final Map<String, TypeSpec> enumerations;
    private final JavaFromXML.ClassType classType;
    private final String salClassName;
    private boolean isInherited = false;

    ClassInfo(String rawClassName, String className, CodegenMojo mojo, String packageName, Map<String, Variable> variableNamesAndTypesMap, Map<String, EnumValues> enumMap, JavaFromXML.ClassType classType, String salClassName) {
        boolean isState;
        this.className = ClassInfo.computeClassName(className, classType);
        this.packageName = ClassInfo.computePackageName(classType, packageName);
        this.superClassName = ClassInfo.computeSuperClass(classType, mojo);
        this.enumerations = ClassInfo.computeEnumerations(enumMap);
        this.originalVariableNamesAndTypesMap = variableNamesAndTypesMap;
        this.convertedVariableNamesAndTypesMap = this.convertToTypeMap(variableNamesAndTypesMap);
        this.classType = classType;
        this.salClassName = salClassName;
        boolean bl = isState = classType == JavaFromXML.ClassType.STATE;
        if (isState) {
            String type = className.replace("Event", "").replace("Detailed", "");
            String values = enumMap.values().iterator().next().getEnumConstants();
            this.enumerations.clear();
            TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((String)type).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SALEnum.class);
            for (String value : values.split(",")) {
                enumBuilder.addEnumConstant(value.trim());
            }
            this.enumerations.put("substate", enumBuilder.build());
            this.convertedVariableNamesAndTypesMap.remove("summaryState");
            this.convertedVariableNamesAndTypesMap.put("substate", (TypeName)ClassName.bestGuess((String)type));
        }
    }

    boolean checkIfCanInherit(List<ClassInfo> possibleSuperClasses) {
        for (ClassInfo info : possibleSuperClasses) {
            if (!info.className.equals(this.className) || !info.originalVariableNamesAndTypesMap.equals(this.originalVariableNamesAndTypesMap)) continue;
            this.packageName = info.packageName;
            this.isInherited = true;
            this.originalVariableNamesAndTypesMap.forEach((name, type) -> {
                if (this.enumerations.containsKey(name)) {
                    ClassName typeName = ClassName.get((String)(this.packageName + "." + this.className), (String)JavaFromXML.capitalize(type.getType()), (String[])new String[0]);
                    if (type.isJavaArray()) {
                        typeName = ArrayTypeName.of((TypeName)typeName);
                    }
                    this.convertedVariableNamesAndTypesMap.put((String)name, (TypeName)typeName);
                }
            });
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, TypeName> getVariableNamesAndTypesMap() {
        return this.convertedVariableNamesAndTypesMap;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public Set<TypeSpec> getEnumerations() {
        return new HashSet<TypeSpec>(this.enumerations.values());
    }

    JavaFromXML.ClassType getClassType() {
        return this.classType;
    }

    private static String computeClassName(String className, JavaFromXML.ClassType classType) {
        switch (classType) {
            case STATE: 
            case EVENT: {
                return className + "Event";
            }
            case TELEMETRY: {
                return className + "Telemetry";
            }
            case COMMAND: {
                return className + "Command";
            }
        }
        return className;
    }

    private static String computePackageName(JavaFromXML.ClassType classType, String basePackageName) {
        switch (classType) {
            case STATE: {
                return basePackageName + ".states";
            }
            case EVENT: {
                return basePackageName + ".event";
            }
            case TELEMETRY: {
                return basePackageName + ".telemetry";
            }
            case COMMAND: {
                return basePackageName + ".command";
            }
        }
        return basePackageName;
    }

    private static String computeSuperClass(JavaFromXML.ClassType classType, CodegenMojo mojo) {
        switch (classType) {
            case STATE: {
                return mojo.getStateParent();
            }
            case EVENT: {
                return mojo.getEventParent();
            }
            case TELEMETRY: {
                return mojo.getTelemetryParent();
            }
        }
        return mojo.getCommandParent();
    }

    private Map<String, TypeName> convertToTypeMap(Map<String, Variable> variableNamesAndTypesMap) {
        LinkedHashMap<String, TypeName> result = new LinkedHashMap<String, TypeName>();
        variableNamesAndTypesMap.forEach((name, type) -> {
            result.put((String)name, this.mapVariableTypeToJava((Variable)type, (String)name));
            this.variableNamesAndCounts.put((String)name, (Variable)type);
        });
        return result;
    }

    private TypeName mapVariableTypeToJava(Variable variable, String name) {
        String type = variable.getType();
        Object typeName = type.equals("string") ? TypeName.get(String.class) : (type.equals("long long") ? TypeName.LONG : (type.contains("long") ? TypeName.INT : (this.enumerations.containsKey(name) ? ClassName.get((String)(this.packageName + "." + this.className), (String)JavaFromXML.capitalize(type), (String[])new String[0]) : TypeVariableName.get((String)type))));
        if (variable.isJavaArray()) {
            typeName = ArrayTypeName.of((TypeName)typeName);
        }
        return typeName;
    }

    String getClassTypeName() {
        String whatClass = "";
        if (this.classType == JavaFromXML.ClassType.TELEMETRY) {
            whatClass = "telemetry";
        }
        if (this.classType == JavaFromXML.ClassType.COMMAND) {
            whatClass = "command";
        }
        if (this.classType == JavaFromXML.ClassType.EVENT) {
            whatClass = "event";
        }
        if (this.classType == JavaFromXML.ClassType.STATE) {
            whatClass = "state";
        }
        return whatClass;
    }

    String getSALClassName() {
        return this.salClassName;
    }

    Map<String, TypeName> getSuperClassArguments() {
        return this.superClassArguments;
    }

    Map<String, TypeName> getConstructorArguments() {
        LinkedHashMap<String, TypeName> map = new LinkedHashMap<String, TypeName>();
        map.putAll(this.superClassArguments);
        map.putAll(this.convertedVariableNamesAndTypesMap);
        return map;
    }

    private static Map<String, TypeSpec> computeEnumerations(Map<String, EnumValues> enumMap) {
        LinkedHashMap<String, TypeSpec> result = new LinkedHashMap<String, TypeSpec>();
        enumMap.forEach((name, values) -> {
            TypeSpec.Builder enumerationBuilder = TypeSpec.enumBuilder((String)JavaFromXML.capitalize(values.getType())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SALEnum.class);
            for (String value : values.getEnumConstants().split(",")) {
                enumerationBuilder.addEnumConstant(value.trim());
            }
            result.put((String)name, enumerationBuilder.build());
        });
        return result;
    }

    boolean isEnumeration(String name) {
        return this.enumerations.containsKey(name);
    }

    boolean isArray(String name) {
        return this.convertedVariableNamesAndTypesMap.get(name) instanceof ArrayTypeName;
    }

    TypeSpec getEnumerationType(String name) {
        return this.enumerations.get(name);
    }

    int getCount(String name) {
        return this.variableNamesAndCounts.get(name).getCount();
    }

    int getSize(String name) {
        return this.variableNamesAndCounts.get(name).getSize();
    }

    String getGetter(String name) {
        TypeName type = this.convertedVariableNamesAndTypesMap.get(name);
        if (type == null) {
            type = TypeName.INT;
        }
        String stem = type.toString().equalsIgnoreCase("boolean") ? "is" : "get";
        return stem + JavaFromXML.capitalize(name);
    }

    boolean isInherited() {
        return this.isInherited;
    }

    static class Variable {
        private final int count;
        private final int size;
        private final String type;
        private final boolean isJavaArray;

        public Variable(String type, int count, int size, boolean isJavaArray) {
            this.type = type;
            this.count = count;
            this.size = size;
            this.isJavaArray = isJavaArray;
        }

        public int getCount() {
            return this.count;
        }

        public String getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isJavaArray() {
            return this.isJavaArray;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Variable other = (Variable)obj;
            if (this.isJavaArray != other.isJavaArray) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + Objects.hashCode(this.type);
            hash = 23 * hash + (this.isJavaArray ? 1 : 0);
            return hash;
        }
    }

    static class EnumValues {
        private final String type;
        private final String values;

        public EnumValues(String type, String values) {
            this.type = type;
            this.values = values;
        }

        public String getType() {
            return this.type;
        }

        public String getEnumConstants() {
            return this.values;
        }
    }
}

