package org.lsst.sal.codegen;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 *
 * @author Farrukh Azfar, generate JavaCode for SALTelemetry, CameraStateEvent
 * and SALEvent classes - generate: class, constructor, variable declarations,
 * setter getter functions and toString() methods - many thanks to Max Turri for
 * helping with the interface
 *
 */
public class JavaFromXML {

    private final CodegenMojo mojo;

    enum ClassType {
        TELEMETRY("SALTelemetry"), STATE("SALEvent"), EVENT("SALEvent"), COMMAND("SALCommand");
        private final String tag;

        ClassType(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return tag;
        }

    };

    JavaFromXML(CodegenMojo mojo) {

        this.mojo = mojo;
    }

    void execute() throws ParserConfigurationException, SAXException, IOException {

        // first string className,
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();

        XMLReader reader = new XMLReader(mojo);
        ArrayList<ClassInfo> classInfos = new ArrayList<>();
        for (URL xmlURL : mojo.getXMLs()) {
            classInfos.addAll(reader.read(builder, xmlURL, mojo.getBasePackageName()));
        }

        List<URL> xmlInheritURLs = mojo.getInheritXMLs();
        List<ClassInfo> inheritClassInfos = new ArrayList<>();
        for (URL xmlURL : xmlInheritURLs) {
            inheritClassInfos.addAll(reader.read(builder, xmlURL, mojo.getInheritPackageName()));
        }

        for (ClassInfo info : classInfos) {
            info.checkIfCanInherit(inheritClassInfos);
        }

        // write classes
        for (ClassInfo info : classInfos) {
            if (!info.isInherited()) {
                JavaClassWriter writer = new JavaClassWriter(info);
                writer.writeClasses(mojo.getOutputDir().getAbsolutePath());
            }
        }

        //write camera.sal - could it be named something else - 
        SalWriter salWriter = new SalWriter(classInfos, mojo);
        salWriter.writeSalFile();

        TestWriter testGenerator = new TestWriter(classInfos, mojo.getBasePackageName(), mojo.getSalMain());
        testGenerator.writeTestFiles(mojo.getTestOutputDir().getAbsolutePath());

    }

    static String capitalize(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

}
